/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.ServerContext;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.util.VersionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerContext
implements ServerContext {
    private ServletConfig config = null;
    private ServletContext context = null;
    private Container container = null;
    private ScriptSessionManager sessionManager = null;
    private ConverterManager converterManager = null;

    public DefaultServerContext(ServletConfig config, ServletContext context, Container container) {
        this.config = config;
        this.context = context;
        this.container = container;
    }

    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        return this.getScriptSessionManager().getAllScriptSessions();
    }

    @Override
    public Collection<ScriptSession> getScriptSessionsByPage(String url) {
        return this.getScriptSessionManager().getScriptSessionsByPage(url);
    }

    @Override
    public ScriptSession getScriptSessionById(String sessionId) {
        return this.getScriptSessionManager().getScriptSession(sessionId, null, null);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.config;
    }

    @Override
    public ServletContext getServletContext() {
        return this.context;
    }

    @Override
    public String getVersion() {
        return VersionUtil.getVersion();
    }

    @Override
    public String getContextPath() {
        UrlProcessor urlProcessor = this.container.getBean(UrlProcessor.class);
        return urlProcessor.getContextPath();
    }

    protected ScriptSessionManager getScriptSessionManager() {
        if (this.sessionManager == null) {
            this.sessionManager = this.container.getBean(ScriptSessionManager.class);
        }
        return this.sessionManager;
    }

    protected ConverterManager getConverterManager() {
        if (this.converterManager == null) {
            this.converterManager = this.container.getBean(ConverterManager.class);
        }
        return this.converterManager;
    }
}

