/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.export;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Hub;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.event.MessageEvent;
import org.directwebremoting.event.MessageListener;
import org.directwebremoting.extend.CallbackHelper;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.io.RawData;

public class System {
    private static final String ATTRIBUTE_SUBSCRIPTIONS = "org.directwebremoting.export.System.subscriptions";
    private static final Log log = LogFactory.getLog(System.class);

    public void pageLoaded() {
    }

    public void pageUnloaded() {
        WebContext wctx = WebContextFactory.get();
        ScriptSession scriptSession = wctx.getScriptSession();
        log.debug((Object)("scriptSession.invalidate(): " + scriptSession.getId()));
        scriptSession.invalidate();
    }

    public void activateCallback(String key, RawData data) {
        try {
            CallbackHelper.executeCallback(key, data);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to marshall data from callback", (Throwable)ex);
        }
    }

    public void publish(String topic, RawData data) {
        WebContext webContext = WebContextFactory.get();
        ConverterManager converterManager = webContext.getContainer().getBean(ConverterManager.class);
        ServletContext servletContext = webContext.getServletContext();
        Hub hub = HubFactory.get(servletContext);
        MessageEvent event = new MessageEvent(hub, converterManager, data);
        hub.publish(topic, event);
    }

    public void subscribe(String topic, String subscriptionId) {
        WebContext webContext = WebContextFactory.get();
        ServletContext servletContext = webContext.getServletContext();
        Hub hub = HubFactory.get(servletContext);
        ScriptSession session = webContext.getScriptSession();
        BrowserMessageListener subscription = new BrowserMessageListener(session, topic, subscriptionId);
        HashMap<String, BrowserMessageListener> subscriptions = (HashMap<String, BrowserMessageListener>)session.getAttribute(ATTRIBUTE_SUBSCRIPTIONS);
        if (subscriptions == null) {
            subscriptions = new HashMap<String, BrowserMessageListener>();
        }
        subscriptions.put(subscriptionId, subscription);
        session.setAttribute(ATTRIBUTE_SUBSCRIPTIONS, subscriptions);
        hub.subscribe(subscription.topic, subscription);
    }

    public boolean unsubscribe(String subscriptionId) {
        WebContext webContext = WebContextFactory.get();
        ServletContext servletContext = webContext.getServletContext();
        Hub hub = HubFactory.get(servletContext);
        ScriptSession session = webContext.getScriptSession();
        Map subscriptions = (Map)session.getAttribute(ATTRIBUTE_SUBSCRIPTIONS);
        BrowserMessageListener subscription = (BrowserMessageListener)subscriptions.get(subscriptionId);
        return hub.unsubscribe(subscription.topic, subscription);
    }

    protected class BrowserMessageListener
    implements MessageListener {
        protected String topic;
        protected String subscriptionId;
        protected ScriptSession session;

        public BrowserMessageListener(ScriptSession session, String topic, String subscriptionId) {
            this.session = session;
            this.topic = topic;
            this.subscriptionId = subscriptionId;
        }

        public void onMessage(MessageEvent message) {
            ScriptBuffer script = new ScriptBuffer();
            script.appendCall("dwr.hub._remotePublish", this.subscriptionId, message.getRawData());
            this.session.addScript(script);
        }
    }
}

