/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.dwrp.PartialResponse;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollBatch {
    private String batchId;
    private PartialResponse partialResponse;
    private String debug;
    private String page;
    private String windowName;
    private String scriptSessionId;
    private boolean get;
    private Map<String, FormField> allParameters;

    public PollBatch(HttpServletRequest request) throws ServerException {
        this.debug = request.getHeader("User-Agent");
        this.get = "GET".equals(request.getMethod());
        ParseUtil parseUtil = new ParseUtil();
        this.allParameters = parseUtil.parseRequest(request);
        this.parseParameters();
    }

    protected void parseParameters() {
        this.batchId = this.extractParameter(this.allParameters, "batchId");
        this.scriptSessionId = this.extractParameter(this.allParameters, "scriptSessionId");
        this.page = this.extractParameter(this.allParameters, "page");
        this.windowName = this.extractParameter(this.allParameters, "windowName");
        String prString = this.extractParameter(this.allParameters, "partialResponse");
        this.partialResponse = PartialResponse.fromOrdinal(prString);
    }

    protected String extractParameter(Map<String, FormField> parameters, String paramName) {
        FormField formField = parameters.remove(paramName);
        if (formField == null) {
            throw new IllegalArgumentException(Messages.getString("PollHandler.MissingParameter", paramName));
        }
        return formField.getString();
    }

    public String getBatchId() {
        return this.batchId;
    }

    public PartialResponse getPartialResponse() {
        return this.partialResponse;
    }

    public String getScriptSessionId() {
        return this.scriptSessionId;
    }

    public String getPage() {
        return this.page;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean isGet() {
        return this.get;
    }

    public String toString() {
        return "PollBatch[partResp=" + (Object)((Object)this.partialResponse) + ",debug=" + this.debug + "]";
    }
}

