/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEnumAbstractBaseConverter
extends BaseV20Converter
implements Converter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        String value = LocalUtil.decode(iv.getValue());
        try {
            Method getter = paramType.getMethod("forString", String.class);
            Object bean = getter.invoke(paramType, value);
            if (bean == null) {
                throw new MarshallException(paramType, "unknown enum value (" + value + ")");
            }
            return bean;
        }
        catch (NoSuchMethodException e) {
            throw new MarshallException(paramType, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MarshallException(paramType, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MarshallException(paramType, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MarshallException(paramType, (Throwable)e);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        return new NonNestedOutboundVariable('\'' + data.toString() + '\'');
    }
}

