/*
 * Decompiled with CFR 0.152.
 */
package jsx3.gui;

import java.lang.reflect.Constructor;
import jsx3.app.Model;
import jsx3.gui.Block;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.CallbackHelper;
import org.directwebremoting.proxy.Callback;
import org.directwebremoting.proxy.ScriptProxy;
import org.directwebremoting.proxy.io.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window
extends Model {
    public static final String DID_OPEN = "open";
    public static final String WILL_CLOSE = "close";
    public static final String DID_FOCUS = "focus";
    public static final String DID_RESIZE = "resize";
    public static final String PARENT_DID_CLOSE = "pclose";

    public Window(Context context, String extension, ScriptProxy scriptProxy) {
        super(context, extension, scriptProxy);
    }

    public Window(String strName) {
        super(null, null, null);
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("new Window", strName);
        this.setInitScript(script);
    }

    public void open(Callback<Boolean> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + DID_OPEN);
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Boolean.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void close(Callback<Boolean> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + WILL_CLOSE);
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Boolean.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void focus() {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + DID_FOCUS);
        this.getScriptProxy().addScript(script);
    }

    public void isOpen(Callback<Boolean> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "isOpen");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Boolean.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void isParentOpen(Callback<Boolean> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "isParentOpen");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Boolean.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void moveTo(int intOffsetLeft, int intOffsetTop) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "moveTo", intOffsetLeft, intOffsetTop);
        this.getScriptProxy().addScript(script);
    }

    public void constrainToScreen() {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "constrainToScreen");
        this.getScriptProxy().addScript(script);
    }

    public void getOffsetLeft(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "getOffsetLeft");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void getOffsetTop(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "getOffsetTop");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public Block getRootBlock() {
        String extension = "getRootBlock().";
        try {
            Constructor ctor = Block.class.getConstructor(Context.class, String.class, ScriptProxy.class);
            return (Block)ctor.newInstance(this, extension, this.getScriptProxy());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unsupported type: " + Block.class.getName());
        }
    }

    public <T> T getRootBlock(Class<T> returnType) {
        String extension = "getRootBlock().";
        try {
            Constructor<T> ctor = returnType.getConstructor(Context.class, String.class, ScriptProxy.class);
            return ctor.newInstance(this, extension, this.getScriptProxy());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unsupported return type: " + returnType.getName());
        }
    }

    public void repaint(Callback<String> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "repaint");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, String.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void getWidth(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "getWidth");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setWidth(int intWidth) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setWidth", intWidth);
        this.getScriptProxy().addScript(script);
    }

    public void getHeight(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "getHeight");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setHeight(int intHeight) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setHeight", intHeight);
        this.getScriptProxy().addScript(script);
    }

    public void isResizable(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "isResizable");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setResizable(boolean bResizable) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setResizable", bResizable);
        this.getScriptProxy().addScript(script);
    }

    public void isScrollable(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "isScrollable");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setScrollable(boolean bScrollable) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setScrollable", bScrollable);
        this.getScriptProxy().addScript(script);
    }

    public void isDependent(Callback<Integer> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "isDependent");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, Integer.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setDependent(boolean bDependent) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setDependent", bDependent);
        this.getScriptProxy().addScript(script);
    }

    public void getTitle(Callback<String> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + this.getContextPath() + "getTitle");
        if (callback != null) {
            String key = CallbackHelper.saveCallback(callback, String.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        this.getScriptProxy().addScript(script);
    }

    public void setTitle(String strTitle) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall(this.getContextPath() + "setTitle", strTitle);
        this.getScriptProxy().addScript(script);
    }
}

