/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;

public class TableUtils {
    public static Collection getForeignKeysForReferenceField(JavaTypeMapping fieldMapping, AbstractMemberMetaData mmd, boolean autoMode, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        ReferenceMapping refMapping = (ReferenceMapping)fieldMapping;
        JavaTypeMapping[] refJavaTypeMappings = refMapping.getJavaTypeMapping();
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        for (int i = 0; i < refJavaTypeMappings.length; ++i) {
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable;
            JavaTypeMapping implMapping = refJavaTypeMappings[i];
            if (storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implMapping.getType(), clr) == null || implMapping.getNumberOfDatastoreMappings() <= 0 || (referencedTable = storeMgr.getDatastoreClass(implMapping.getType(), clr)) == null || ((fkmd = mmd.getForeignKeyMetaData()) == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
            ForeignKey fk = new ForeignKey(implMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            fks.add(fk);
        }
        return fks;
    }

    public static ForeignKey getForeignKeyForPCField(JavaTypeMapping fieldMapping, AbstractMemberMetaData mmd, boolean autoMode, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        ForeignKeyMetaData fkmd;
        AbstractClassMetaData[] refCmds;
        AbstractClassMetaData refCmd;
        DatastoreClass referencedTable = storeMgr.getDatastoreClass(mmd.getTypeName(), clr);
        if (referencedTable == null && (refCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr)) != null && (refCmds = storeMgr.getClassesManagingTableForClass(refCmd, clr)) != null && refCmds.length == 1) {
            referencedTable = storeMgr.getDatastoreClass(refCmds[0].getFullClassName(), clr);
        }
        if (referencedTable != null && ((fkmd = mmd.getForeignKeyMetaData()) != null && fkmd.getDeleteAction() != ForeignKeyAction.NONE || autoMode)) {
            ForeignKey fk = new ForeignKey(fieldMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            return fk;
        }
        return null;
    }

    public static Index getIndexForField(DatastoreContainerObject table, IndexMetaData imd, JavaTypeMapping fieldMapping) {
        if (fieldMapping.getNumberOfDatastoreMappings() == 0) {
            return null;
        }
        boolean unique = imd.isUnique();
        Index index = new Index(table, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier idxId = idFactory.newIdentifier(IdentifierType.INDEX, imd.getName());
            index.setName(idxId.toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreMappings();
        for (int j = 0; j < countFields; ++j) {
            index.addDatastoreField(fieldMapping.getDatastoreMapping(j).getDatastoreField());
        }
        return index;
    }

    public static CandidateKey getCandidateKeyForField(DatastoreContainerObject table, UniqueMetaData umd, JavaTypeMapping fieldMapping) {
        CandidateKey ck = new CandidateKey(table);
        if (umd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier ckId = idFactory.newIdentifier(IdentifierType.CANDIDATE_KEY, umd.getName());
            ck.setName(ckId.toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreMappings();
        for (int j = 0; j < countFields; ++j) {
            ck.addDatastoreField(fieldMapping.getDatastoreMapping(j).getDatastoreField());
        }
        return ck;
    }
}

