/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.scostore.AbstractArrayStore;
import org.datanucleus.store.mapped.scostore.AbstractArrayStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractCollectionStoreSpecialization;
import org.datanucleus.util.Localiser;

abstract class RDBMSAbstractArrayStoreSpecialization
extends RDBMSAbstractCollectionStoreSpecialization
implements AbstractArrayStoreSpecialization {
    RDBMSAbstractArrayStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(ObjectProvider ownerSM, ElementContainerStore ecs) {
        String clearStmt = this.getClearStmt(ecs);
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = ecs.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearStmt), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] internalAdd(ObjectProvider sm, AbstractArrayStore aas, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        ExecutionContext ec = sm.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt((ElementContainerStore)aas);
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, false);
            boolean notYetFlushedError = false;
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, (BaseContainerStore)aas);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, aas.getElementMapping());
                jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, aas.getOrderMapping());
                if (aas.getRelationDiscriminatorMapping() != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, (ElementContainerStore)aas);
                }
                int[] nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(addStmt, (Throwable)e);
        }
    }

    public void processBatchedWrites(ManagedConnection mconn) throws MappedDatastoreException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            sqlControl.processStatementsForConnection(mconn);
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", (Throwable)e);
        }
    }
}

