/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.BitSet;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.TypeConversionHelper;

public class OracleArrayMapping
extends ArrayMapping {
    public void postInsert(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            Object value = sm.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value == null) {
                return;
            }
            SCOUtils.validateObjectsForWriting((ExecutionContext)sm.getExecutionContext(), (Object)value);
            byte[] bytes = new byte[]{};
            try {
                if (this.mmd.isSerialized()) {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(LOCALISER.msg("055005", (Object)value.getClass().getName()));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                } else if (value instanceof boolean[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanArray((Object)value);
                } else if (value instanceof char[]) {
                    bytes = TypeConversionHelper.getByteArrayFromCharArray((Object)value);
                } else if (value instanceof double[]) {
                    bytes = TypeConversionHelper.getByteArrayFromDoubleArray((Object)value);
                } else if (value instanceof float[]) {
                    bytes = TypeConversionHelper.getByteArrayFromFloatArray((Object)value);
                } else if (value instanceof int[]) {
                    bytes = TypeConversionHelper.getByteArrayFromIntArray((Object)value);
                } else if (value instanceof long[]) {
                    bytes = TypeConversionHelper.getByteArrayFromLongArray((Object)value);
                } else if (value instanceof short[]) {
                    bytes = TypeConversionHelper.getByteArrayFromShortArray((Object)value);
                } else if (value instanceof Boolean[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanObjectArray((Object)value);
                } else if (value instanceof Byte[]) {
                    bytes = TypeConversionHelper.getByteArrayFromByteObjectArray((Object)value);
                } else if (value instanceof Character[]) {
                    bytes = TypeConversionHelper.getByteArrayFromCharObjectArray((Object)value);
                } else if (value instanceof Double[]) {
                    bytes = TypeConversionHelper.getByteArrayFromDoubleObjectArray((Object)value);
                } else if (value instanceof Float[]) {
                    bytes = TypeConversionHelper.getByteArrayFromFloatObjectArray((Object)value);
                } else if (value instanceof Integer[]) {
                    bytes = TypeConversionHelper.getByteArrayFromIntObjectArray((Object)value);
                } else if (value instanceof Long[]) {
                    bytes = TypeConversionHelper.getByteArrayFromLongObjectArray((Object)value);
                } else if (value instanceof Short[]) {
                    bytes = TypeConversionHelper.getByteArrayFromShortObjectArray((Object)value);
                } else if (value instanceof BigDecimal[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBigDecimalArray((Object)value);
                } else if (value instanceof BigInteger[]) {
                    bytes = TypeConversionHelper.getByteArrayFromBigIntegerArray((Object)value);
                } else if (value instanceof byte[]) {
                    bytes = (byte[])value;
                } else if (value instanceof BitSet) {
                    bytes = TypeConversionHelper.getByteArrayFromBooleanArray((Object)TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
                } else {
                    if (!(value instanceof Serializable)) {
                        throw new NucleusDataStoreException(LOCALISER.msg("055005", (Object)value.getClass().getName()));
                    }
                    BlobImpl b = new BlobImpl(value);
                    bytes = b.getBytes(0L, (int)b.length());
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.mmd, (Object)e.getMessage()), (Throwable)e);
            }
            catch (IOException e1) {
                // empty catch block
            }
            OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDatastoreMapping(0), bytes);
        } else {
            super.postInsert(sm);
        }
    }

    public void postUpdate(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            this.postInsert(sm);
        } else {
            super.postUpdate(sm);
        }
    }
}

