/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public class RDBMSPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MappedStoreManager storeMgr;
    private Map<RequestIdentifier, Request> requestsByID = Collections.synchronizedMap(new SoftValueMap());

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, sm.getLoadedFieldNumbers());
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        String className = sm.getObject().getClass().getName();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(className, clr);
        if (dc == null) {
            if (sm.getClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("032013", (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("032014", (Object)className, (Object)sm.getClassMetaData().getInheritanceMetaData().getStrategy())).setFatal();
        }
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
        this.insertTable(dc, sm, clr);
    }

    private void insertTable(DatastoreClass table, ObjectProvider sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform InsertRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertTable(supertable, sm, clr);
        }
        Request req = this.getInsertRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.insertTable((DatastoreClass)secTable, sm, clr);
            }
        }
    }

    private Request getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.INSERT, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.insert");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.INSERT.toString(), key}, "class", new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, new Object[]{table, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(ObjectProvider op, int[] memberNumbers) {
        AbstractMemberMetaData[] mmds = null;
        if (memberNumbers != null && memberNumbers.length > 0) {
            int i;
            int[] memberNumbersToProcess = memberNumbers;
            AbstractClassMetaData cmd = op.getClassMetaData();
            ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
            if (op.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.rdbms.fetchUnloadedAutomatically") && !op.getLifecycleState().isDeleted()) {
                boolean fetchPerformsSelect = false;
                for (i = 0; i < memberNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if (relationType == 3 || relationType == 4 || relationType == 5) continue;
                    fetchPerformsSelect = true;
                    break;
                }
                if (fetchPerformsSelect) {
                    int i2;
                    ArrayList<Integer> memberNumberList = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < memberNumbers.length; ++i3) {
                        memberNumberList.add(memberNumbers[i3]);
                    }
                    boolean[] loadedFlags = op.getLoadedFields();
                    for (i2 = 0; i2 < loadedFlags.length; ++i2) {
                        AbstractMemberMetaData mmd;
                        int relType;
                        boolean requested = false;
                        for (int j = 0; j < memberNumbers.length; ++j) {
                            if (memberNumbers[j] != i2) continue;
                            requested = true;
                            break;
                        }
                        if (requested || loadedFlags[i2] || (relType = (mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i2)).getRelationType(clr)) != 0 && relType != 2 && relType != 1) continue;
                        memberNumberList.add(i2);
                    }
                    memberNumbersToProcess = new int[memberNumberList.size()];
                    i2 = 0;
                    Iterator fieldNumberIter = memberNumberList.iterator();
                    while (fieldNumberIter.hasNext()) {
                        memberNumbersToProcess[i2++] = (Integer)fieldNumberIter.next();
                    }
                }
            }
            mmds = new AbstractMemberMetaData[memberNumbersToProcess.length];
            for (int i4 = 0; i4 < mmds.length; ++i4) {
                mmds[i4] = cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberNumbersToProcess[i4]);
            }
            if (op.getPcObjectType() != 0) {
                StringBuffer str = new StringBuffer();
                for (i = 0; i < mmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(mmds[i].getName());
                }
                NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + op.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
            } else {
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementFetchCount();
                }
                DatastoreClass table = this.storeMgr.getDatastoreClass(op.getObject().getClass().getName(), clr);
                Request req = this.getFetchRequest(table, mmds, op.getObject().getClass(), clr);
                req.execute(op);
            }
        }
    }

    private Request getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.FETCH, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.fetch");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.FETCH.toString(), key}, "class", new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, new Object[]{table, mmds, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate fetch request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, fieldNumbers);
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
            ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
            DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
            this.updateTable(dc, sm, clr, fmds);
        }
    }

    private void updateTable(DatastoreClass table, ObjectProvider sm, ClassLoaderResolver clr, AbstractMemberMetaData[] fieldMetaData) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform UpdateRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateTable(supertable, sm, clr, fieldMetaData);
        }
        Request req = this.getUpdateRequest(table, fieldMetaData, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.updateTable((DatastoreClass)secTable, sm, clr, fieldMetaData);
            }
        }
    }

    private Request getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.UPDATE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.update");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.UPDATE.toString(), key}, "class", new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, new Object[]{table, mmds, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementDeleteCount();
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        this.deleteTable(dc, sm, clr);
    }

    private void deleteTable(DatastoreClass table, ObjectProvider sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform DeleteRequest on RDBMS view " + table);
        }
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.deleteTable((DatastoreClass)secTable, sm, clr);
            }
        }
        Request req = this.getDeleteRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteTable(supertable, sm, clr);
        }
    }

    private Request getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.DELETE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.delete");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.DELETE.toString(), key}, "class", new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, new Object[]{table, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObject(ObjectProvider sm) {
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        Request req = this.getLocateRequest(table, sm.getObject().getClass().getName());
        req.execute(sm);
    }

    private Request getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.LOCATE, className);
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.locate");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.LOCATE.toString(), key}, "class", new Class[]{DatastoreClass.class}, new Object[]{table});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            HashSet<RequestIdentifier> keySet = new HashSet<RequestIdentifier>(this.requestsByID.keySet());
            for (RequestIdentifier reqId : keySet) {
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }

    private void checkForSchemaUpdatesForFieldsOfObject(ObjectProvider sm, int[] fieldNumbers) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSStoreManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.requestsByID.clear();
            }
        }
    }
}

