/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.core.plugins.RemotePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloader
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDownloader.class);
    private TempDirectories workingDirectories;
    private ServerClient server;

    public PluginDownloader(TempDirectories workingDirectories, ServerClient server) {
        this.workingDirectories = workingDirectories;
        this.server = server;
    }

    public List<File> downloadPlugin(RemotePlugin remote) {
        try {
            File targetDir = this.workingDirectories.getDir("plugins/" + remote.getKey());
            FileUtils.forceMkdir((File)targetDir);
            LOG.debug("Downloading plugin " + remote.getKey() + " into " + targetDir);
            ArrayList files = Lists.newArrayList();
            for (String filename : remote.getFilenames()) {
                String url = "/deploy/plugins/" + remote.getKey() + "/" + filename;
                File toFile = new File(targetDir, filename);
                this.server.download(url, toFile);
                files.add(toFile);
            }
            return files;
        }
        catch (Exception e) {
            throw new SonarException("Fail to download plugin: " + remote.getKey(), (Throwable)e);
        }
    }

    public List<RemotePlugin> downloadPluginIndex() {
        String url = "/deploy/plugins/index.txt";
        try {
            LOG.debug("Downloading index of plugins");
            String indexContent = this.server.request(url);
            String[] rows = StringUtils.split((String)indexContent, (char)'\n');
            ArrayList remoteLocations = Lists.newArrayList();
            for (String row : rows) {
                remoteLocations.add(RemotePlugin.unmarshal((String)row));
            }
            return remoteLocations;
        }
        catch (Exception e) {
            throw new SonarException("Fail to download plugins index: " + url, (Throwable)e);
        }
    }
}

