/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class DurationLabel {
    private String suffixAgo = "ago";
    private String seconds = "less than a minute";
    private String minute = "about a minute";
    private String minutes = "{0} minutes";
    private String hour = "about an hour";
    private String hours = "{0} hours";
    private String day = "a day";
    private String days = "{0} days";
    private String month = "about a month";
    private String months = "{0} months";
    private String year = "about a year";
    private String years = "{0} years";

    public String label(long durationInMillis) {
        double nbSeconds = (double)durationInMillis / 1000.0;
        double nbMinutes = nbSeconds / 60.0;
        double nbHours = nbMinutes / 60.0;
        double nbDays = nbHours / 24.0;
        double nbYears = nbDays / 365.0;
        String message = this.getMessage(nbSeconds, nbMinutes, nbHours, nbDays, nbYears);
        return this.join(message, this.suffixAgo);
    }

    private String getMessage(double nbSeconds, double nbMinutes, double nbHours, double nbDays, double nbYears) {
        String message = MessageFormat.format(this.years, Math.floor(nbYears));
        if (nbSeconds < 45.0) {
            message = this.seconds;
        } else if (nbSeconds < 90.0) {
            message = this.minute;
        } else if (nbMinutes < 45.0) {
            message = MessageFormat.format(this.minutes, Math.round(nbMinutes));
        } else if (nbMinutes < 90.0) {
            message = this.hour;
        } else if (nbHours < 24.0) {
            message = MessageFormat.format(this.hours, Math.round(nbHours));
        } else if (nbHours < 48.0) {
            message = this.day;
        } else if (nbDays < 30.0) {
            message = MessageFormat.format(this.days, Math.floor(nbDays));
        } else if (nbDays < 60.0) {
            message = this.month;
        } else if (nbDays < 365.0) {
            message = MessageFormat.format(this.months, Math.floor(nbDays / 30.0));
        } else if (nbYears < 2.0) {
            message = this.year;
        }
        return message;
    }

    @VisibleForTesting
    String join(String time, String suffix) {
        StringBuilder joined = new StringBuilder();
        joined.append(time);
        if (StringUtils.isNotBlank((String)suffix)) {
            joined.append(' ').append(suffix);
        }
        return joined.toString();
    }

    public String getSuffixAgo() {
        return this.suffixAgo;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getHour() {
        return this.hour;
    }

    public String getHours() {
        return this.hours;
    }

    public String getDay() {
        return this.day;
    }

    public String getDays() {
        return this.days;
    }

    public String getMonth() {
        return this.month;
    }

    public String getMonths() {
        return this.months;
    }

    public String getYear() {
        return this.year;
    }

    public String getYears() {
        return this.years;
    }
}

