/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.Session;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.utils.CqlOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLDataLoader {
    private static final Logger log = LoggerFactory.getLogger(CQLDataLoader.class);
    public static final String DEFAULT_KEYSPACE_NAME = "cassandraunitkeyspace";
    private final Session session;

    public Session getSession() {
        return this.session;
    }

    public CQLDataLoader(Session session) {
        this.session = session;
    }

    public void load(CQLDataSet dataSet) {
        this.initKeyspaceContext(this.session, dataSet);
        log.debug("loading data");
        dataSet.getCQLStatements().stream().forEach(CqlOperations.execute(this.session));
        if (dataSet.getKeyspaceName() != null) {
            CqlOperations.use(this.session).accept(dataSet.getKeyspaceName());
        }
    }

    private void initKeyspaceContext(Session session, CQLDataSet dataSet) {
        String keyspaceName = DEFAULT_KEYSPACE_NAME;
        if (dataSet.getKeyspaceName() != null) {
            keyspaceName = dataSet.getKeyspaceName();
        }
        log.debug("initKeyspaceContext : keyspaceDeletion={} keyspaceCreation={} ;keyspaceName={}", new Object[]{dataSet.isKeyspaceDeletion(), dataSet.isKeyspaceCreation(), keyspaceName});
        if (dataSet.isKeyspaceDeletion()) {
            CqlOperations.dropKeyspace(session).accept(keyspaceName);
        }
        if (dataSet.isKeyspaceCreation()) {
            CqlOperations.createKeyspace(session).accept(keyspaceName);
            CqlOperations.use(session).accept(keyspaceName);
        }
    }
}

