/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algorithmIdentifier.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure((ASN1Sequence)subjectPublicKeyInfo.getPublicKey());
            return new RSAKeyParameters(false, rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
        }
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement) || algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHParameter dHParameter = new DHParameter((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)subjectPublicKeyInfo.getPublicKey();
            BigInteger bigInteger = dHParameter.getL();
            int n = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n);
            return new DHPublicKeyParameters(dERInteger.getValue(), dHParameters);
        }
        if (algorithmIdentifier.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            DERInteger dERInteger = (DERInteger)subjectPublicKeyInfo.getPublicKey();
            return new ElGamalPublicKeyParameters(dERInteger.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_dsa) || algorithmIdentifier.getObjectId().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            DERInteger dERInteger = (DERInteger)subjectPublicKeyInfo.getPublicKey();
            DEREncodable dEREncodable = subjectPublicKeyInfo.getAlgorithmId().getParameters();
            DSAParameters dSAParameters = null;
            if (dEREncodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance(dEREncodable.getDERObject());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPublicKeyParameters(dERInteger.getValue(), dSAParameters);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            Object object;
            ASN1Encodable aSN1Encodable;
            X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECDomainParameters eCDomainParameters = null;
            if (x962Parameters.isNamedCurve()) {
                aSN1Encodable = (DERObjectIdentifier)x962Parameters.getParameters();
                object = X962NamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                if (object == null && (object = SECNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable)) == null && (object = NISTNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable)) == null) {
                    object = TeleTrusTNamedCurves.getByOID((DERObjectIdentifier)aSN1Encodable);
                }
                eCDomainParameters = new ECDomainParameters(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH(), ((X9ECParameters)object).getSeed());
            } else {
                aSN1Encodable = new X9ECParameters((ASN1Sequence)x962Parameters.getParameters());
                eCDomainParameters = new ECDomainParameters(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getG(), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH(), ((X9ECParameters)aSN1Encodable).getSeed());
            }
            aSN1Encodable = subjectPublicKeyInfo.getPublicKeyData();
            object = ((DERBitString)aSN1Encodable).getBytes();
            DEROctetString dEROctetString = new DEROctetString((byte[])object);
            X9ECPoint x9ECPoint = new X9ECPoint(eCDomainParameters.getCurve(), dEROctetString);
            return new ECPublicKeyParameters(x9ECPoint.getPoint(), eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

