/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.EphemeralKeyPair;
import org.bouncycastle.crypto.KeyEncoder;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.EphemeralKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637KDFCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.PGPUtil;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            if (pGPPublicKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                X9ECParameters x9ECParameters = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)eCDHPublicBCPGKey.getCurveOID());
                ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
                ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
                eCKeyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(eCDomainParameters, this.random));
                EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)eCKeyPairGenerator, new KeyEncoder(){

                    public byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
                        return ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false);
                    }
                });
                EphemeralKeyPair ephemeralKeyPair = ephemeralKeyPairGenerator.generate();
                ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ephemeralKeyPair.getKeyPair().getPrivate();
                ECPoint eCPoint = eCDHPublicBCPGKey.getPoint().multiply(eCPrivateKeyParameters.getD()).normalize();
                RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(this.digestCalculatorProviderBuilder.build().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                SecretKeySpec secretKeySpec = new SecretKeySpec(rFC6637KDFCalculator.createKey(eCDHPublicBCPGKey.getCurveOID(), eCPoint, pGPPublicKey.getFingerprint()), "AESWrap");
                Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                cipher.init(3, (Key)secretKeySpec, this.random);
                byte[] byArray2 = PGPUtil.padSessionData(byArray);
                byte[] byArray3 = cipher.wrap(new SecretKeySpec(byArray2, PGPUtil.getSymmetricCipherName(byArray[0])));
                byte[] byArray4 = new MPInteger(new BigInteger(1, ephemeralKeyPair.getEncodedPublicKey())).getEncoded();
                byte[] byArray5 = new byte[byArray4.length + 1 + byArray3.length];
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                byArray5[byArray4.length] = (byte)byArray3.length;
                System.arraycopy(byArray3, 0, byArray5, byArray4.length + 1, byArray3.length);
                return byArray5;
            }
            Cipher cipher = this.helper.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            PublicKey publicKey = this.keyConverter.getPublicKey(pGPPublicKey);
            cipher.init(1, (Key)publicKey, this.random);
            return cipher.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IOException iOException) {
            throw new PGPException("unable to encode MPI: " + iOException.getMessage(), iOException);
        }
    }
}

