/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.openpgp.PGPException;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int n) throws PGPException {
        switch (n) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int n, int n2) throws PGPException {
        switch (n) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(n2));
            }
            case 17: {
                return new DSADigestSigner((DSA)new DSASigner(), BcImplProvider.createDigest(n2));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm");
    }

    static BlockCipher createBlockCipher(int n) throws PGPException {
        AESEngine aESEngine;
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                aESEngine = new AESEngine();
                break;
            }
            case 4: {
                aESEngine = new BlowfishEngine();
                break;
            }
            case 3: {
                aESEngine = new CAST5Engine();
                break;
            }
            case 6: {
                aESEngine = new DESEngine();
                break;
            }
            case 10: {
                aESEngine = new TwofishEngine();
                break;
            }
            case 2: {
                aESEngine = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return aESEngine;
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int n) throws PGPException {
        PKCS1Encoding pKCS1Encoding;
        switch (n) {
            case 1: 
            case 2: {
                pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + n);
            }
        }
        return pKCS1Encoding;
    }
}

