/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Crypts;
import org.json.JSONObject;

public final class Sessions {
    private static final Logger LOGGER = Logger.getLogger(Sessions.class);
    private static final int COOKIE_EXPIRY = 2592000;
    public static final String COOKIE_NAME;
    public static final String COOKIE_SECRET;
    public static final boolean COOKIE_HTTP_ONLY;

    private Sessions() {
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, JSONObject user) {
        HttpSession session = request.getSession(false);
        if (null == session) {
            LOGGER.warn("The session is null");
            return;
        }
        session.setAttribute("user", (Object)user);
        try {
            JSONObject cookieJSONObject = new JSONObject();
            cookieJSONObject.put(Keys.OBJECT_ID, user.optString(Keys.OBJECT_ID));
            cookieJSONObject.put("userPassword", user.optString("userPassword"));
            String random = RandomStringUtils.random((int)16);
            cookieJSONObject.put("token", user.optString("userPassword") + ":" + random);
            String cookieValue = Crypts.encryptByAES(cookieJSONObject.toString(), COOKIE_SECRET);
            Cookie cookie = new Cookie(COOKIE_NAME, cookieValue);
            cookie.setPath("/");
            cookie.setMaxAge(2592000);
            cookie.setHttpOnly(COOKIE_HTTP_ONLY);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Can not write cookie", e);
        }
    }

    public static boolean logout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            Cookie cookie = new Cookie(COOKIE_NAME, null);
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
            session.invalidate();
            return true;
        }
        return false;
    }

    public static JSONObject currentUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            return (JSONObject)session.getAttribute("user");
        }
        return null;
    }

    public static String currentUserPwd(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userPassword");
        }
        return null;
    }

    public static String currentUserName(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userName");
        }
        return null;
    }

    public static String currentUserEmail(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (null != session) {
            JSONObject user = (JSONObject)session.getAttribute("user");
            return user.optString("userEmail");
        }
        return null;
    }

    static {
        String cookieNameConf = Latkes.getLatkeProperty("cookieName");
        if (StringUtils.isBlank((String)cookieNameConf)) {
            cookieNameConf = "b3log-latke";
        }
        COOKIE_NAME = cookieNameConf;
        String cookieSecret = Latkes.getLatkeProperty("cookieSecret");
        if (StringUtils.isBlank((String)cookieSecret)) {
            cookieSecret = "Beyond";
        }
        COOKIE_SECRET = cookieSecret;
        COOKIE_HTTP_ONLY = Boolean.valueOf(Latkes.getLocalProperty("cookieHttpOnly"));
    }
}

