/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Execs {
    private static final Logger LOGGER = Logger.getLogger(Execs.class);

    private Execs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exec(String cmd) {
        String string;
        InputStream inputStream = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            Thread t = new Thread(new InputStreamRunnable(p.getErrorStream()));
            t.start();
            inputStream = p.getInputStream();
            String result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            p.destroy();
            string = result;
        }
        catch (IOException e) {
            String string2;
            try {
                LOGGER.log(Level.ERROR, "Executes command [" + cmd + "] failed", e);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exec(String[] cmds) {
        String string;
        InputStream inputStream = null;
        try {
            Process p = Runtime.getRuntime().exec(cmds);
            Thread t = new Thread(new InputStreamRunnable(p.getErrorStream()));
            t.start();
            inputStream = p.getInputStream();
            String result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            p.destroy();
            string = result;
        }
        catch (IOException e) {
            String string2;
            try {
                LOGGER.log(Level.ERROR, "Executes commands [" + Arrays.toString(cmds) + "] failed", e);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    private static class InputStreamRunnable
    implements Runnable {
        private BufferedReader bufferedReader;

        public InputStreamRunnable(InputStream is) {
            try {
                this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(is), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Constructs input stream handle thread failed", e);
            }
        }

        @Override
        public void run() {
            try {
                String s;
                while (null != (s = this.bufferedReader.readLine())) {
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((Reader)this.bufferedReader);
            }
        }
    }
}

