/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Crypts {
    private static final Logger LOGGER = Logger.getLogger(Crypts.class);
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encryptByAES(String content, String key) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("UTF-8");
            cipher.init(1, keySpec);
            byte[] result = cipher.doFinal(byteContent);
            return Crypts.encodeHexString(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Encrypt failed", e);
            return null;
        }
    }

    public static String decryptByAES(String content, String key) {
        try {
            byte[] data = Crypts.decodeHex(content.toCharArray());
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keySpec);
            byte[] result = cipher.doFinal(data);
            return new String(result, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Decrypt failed", new Object[0]);
            return null;
        }
    }

    private static String encodeHexString(byte[] data) {
        return new String(Crypts.encodeHex(data));
    }

    private static char[] encodeHex(byte[] data) {
        return Crypts.encodeHex(data, true);
    }

    private static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Crypts.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int var5 = 0;
        for (int i = 0; i < l; ++i) {
            out[var5++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[var5++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static byte[] decodeHex(char[] data) throws Exception {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new Exception("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Crypts.toDigit(data[j], j) << 4;
            f |= Crypts.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) throws Exception {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new Exception("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    private Crypts() {
    }
}

