/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static List<Integer> getRandomIntegers(int start, int end, int size) {
        if (size > end - start + 1) {
            throw new IllegalArgumentException("The specified size more then (end - start + 1)!");
        }
        List<Integer> integers = CollectionUtils.genIntegers(start, end);
        ArrayList<Integer> ret = new ArrayList<Integer>();
        while (ret.size() < size) {
            int remainsSize = integers.size();
            int index = (int)(Math.random() * (double)(remainsSize - 1));
            Integer i = integers.get(index);
            ret.add(i);
            integers.remove(i);
        }
        return ret;
    }

    public static List<Integer> genIntegers(int start, int end) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i <= end; ++i) {
            ret.add(i + start);
        }
        return ret;
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        if (null == array) {
            return Collections.emptySet();
        }
        HashSet<T> ret = new HashSet<T>();
        for (int i = 0; i < array.length; ++i) {
            T object = array[i];
            ret.add(object);
        }
        return ret;
    }

    public static <T> JSONArray listToJSONArray(List<T> list) {
        JSONArray ret = new JSONArray();
        if (null == list) {
            return ret;
        }
        for (T object : list) {
            ret.put(object);
        }
        return ret;
    }

    public static <T> JSONArray toJSONArray(Collection<T> collection) {
        JSONArray ret = new JSONArray();
        if (null == collection) {
            return ret;
        }
        for (T object : collection) {
            ret.put(object);
        }
        return ret;
    }

    public static <T> Set<T> jsonArrayToSet(JSONArray jsonArray) {
        if (null == jsonArray) {
            return Collections.emptySet();
        }
        HashSet<Object> ret = new HashSet<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ret.add(jsonArray.opt(i));
        }
        return ret;
    }

    public static <T> List<T> jsonArrayToList(JSONArray jsonArray) {
        if (null == jsonArray) {
            return Collections.emptyList();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ret.add(jsonArray.opt(i));
        }
        return ret;
    }

    public static <T> T[] jsonArrayToArray(JSONArray jsonArray, Class<? extends T[]> newType) {
        if (null == jsonArray) {
            return new Object[0];
        }
        int newLength = jsonArray.length();
        Object[] original = new Object[newLength];
        for (int i = 0; i < newLength; ++i) {
            original[i] = jsonArray.opt(i);
        }
        return Arrays.copyOf(original, newLength, newType);
    }
}

