/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch.local;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.urlfetch.HTTPHeader;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;

class UrlFetchCommonHandler {
    private static final Logger LOGGER = Logger.getLogger(UrlFetchCommonHandler.class);

    UrlFetchCommonHandler() {
    }

    protected HTTPResponse doFetch(HTTPRequest request) throws IOException {
        HttpURLConnection httpURLConnection = this.prepareConnection(request);
        this.configConnection(httpURLConnection, request);
        httpURLConnection.connect();
        HTTPResponse ret = this.resultConnection(httpURLConnection);
        httpURLConnection.disconnect();
        return ret;
    }

    protected HttpURLConnection prepareConnection(HTTPRequest request) throws IOException {
        if (request.getURL() == null) {
            throw new IOException("URL for URLFetch should not be null");
        }
        HttpURLConnection ret = (HttpURLConnection)request.getURL().openConnection();
        ret.setRequestMethod(request.getRequestMethod().toString());
        for (HTTPHeader httpHeader : request.getHeaders()) {
            ret.setRequestProperty(httpHeader.getName(), httpHeader.getValue());
        }
        return ret;
    }

    protected void configConnection(HttpURLConnection httpURLConnection, HTTPRequest request) throws IOException {
        httpURLConnection.setConnectTimeout(request.getConnectTimeout());
        httpURLConnection.setReadTimeout(request.getReadTimeout());
    }

    protected HTTPResponse resultConnection(HttpURLConnection httpURLConnection) throws IOException {
        HTTPResponse ret = new HTTPResponse();
        ret.setResponseCode(httpURLConnection.getResponseCode());
        ret.setFinalURL(httpURLConnection.getURL());
        InputStream retStream = 200 <= ret.getResponseCode() && ret.getResponseCode() < 400 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        ret.setContent(this.inputStreamToByte(retStream));
        this.fillHttpResponseHeader(ret, httpURLConnection.getHeaderFields());
        return ret;
    }

    protected void fillHttpResponseHeader(HTTPResponse httpResponse, Map<String, List<String>> headerFields) {
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            httpResponse.addHeader(new HTTPHeader(entry.getKey(), entry.getValue().toString()));
        }
    }

    private byte[] inputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] ret = bytestream.toByteArray();
        bytestream.close();
        return ret;
    }

    static {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Init SSL context failed", e);
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

