/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.taskqueue.local;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.taskqueue.Queue;
import org.b3log.latke.taskqueue.TaskQueueService;
import org.b3log.latke.taskqueue.local.LocalTaskQueue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class LocalTaskQueueService
implements TaskQueueService {
    private static final Logger LOGGER = Logger.getLogger(LocalTaskQueueService.class);
    private static Map<String, Queue> queueMap = new Hashtable<String, Queue>();
    private static boolean inited;

    public static void init() {
        File queueXml = Latkes.getWebFile("/WEB-INF/queue.xml");
        if (null == queueXml || !queueXml.exists()) {
            LOGGER.log(Level.INFO, "Not found [queue.xml], assuming queue tasks", new Object[0]);
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(queueXml);
            Element root = document.getDocumentElement();
            root.normalize();
            NodeList queueRoot = root.getElementsByTagName("queue-entries");
            LOGGER.log(Level.DEBUG, "Reading tasks: ", new Object[0]);
            for (int i = 0; i < queueRoot.getLength(); ++i) {
                Element queueNode = (Element)queueRoot.item(i);
                String queueName = queueNode.getElementsByTagName("name").item(0).getTextContent();
                Element rparamNode = (Element)queueNode.getElementsByTagName("retry-parameters").item(0);
                String retryLimit = rparamNode.getElementsByTagName("task-retry-limit").item(0).getTextContent();
                queueMap.put(queueName, new LocalTaskQueue(Integer.valueOf(retryLimit)));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads queue.xml failed", e);
            throw new RuntimeException(e);
        }
        inited = true;
    }

    @Override
    public Queue getQueue(String queueName) {
        if (!inited) {
            LocalTaskQueueService.init();
        }
        return queueMap.get(queueName);
    }
}

