/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.converter;

import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.servlet.converter.IStringConvert;
import org.b3log.latke.servlet.converter.StringToIntergerConvert;
import org.b3log.latke.servlet.converter.StringToStringConvert;

public final class StringConverters {
    private static Map<Class<?>, IStringConvert<?>> converMap = new HashMap();

    private StringConverters() {
    }

    public static void registerConverter(Class<?> clazz, IStringConvert<?> convert) {
        converMap.put(clazz, convert);
    }

    public static <T> T convert(String name, String value, Class<T> clazz) {
        IStringConvert<?> convert = converMap.get(clazz);
        if (convert != null) {
            return (T)converMap.get(clazz).doConvert(value);
        }
        return null;
    }

    static {
        StringConverters.registerConverter(String.class, new StringToStringConvert());
        StringConverters.registerConverter(Integer.class, new StringToIntergerConvert());
    }
}

