/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.converter;

import java.util.ArrayList;
import java.util.List;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.converter.ContextConvert;
import org.b3log.latke.servlet.converter.IConverters;
import org.b3log.latke.servlet.converter.JSONObjectConvert;
import org.b3log.latke.servlet.converter.PathVariableConvert;
import org.b3log.latke.servlet.converter.RendererConvert;
import org.b3log.latke.servlet.converter.RequestConvert;
import org.b3log.latke.servlet.converter.ResponseConvert;
import org.b3log.latke.servlet.handler.MatchResult;

public final class Converters {
    private static final List<IConverters> CONVERTERS_LIST = new ArrayList<IConverters>();

    private Converters() {
    }

    public static void registerConverters(IConverters converter) {
        CONVERTERS_LIST.add(converter);
    }

    public static Object doConvert(Class<?> parameterType, String paramterName, HTTPRequestContext context, MatchResult result, int sequence) {
        for (IConverters iConverters : CONVERTERS_LIST) {
            if (!iConverters.isMatched(parameterType, paramterName).booleanValue()) continue;
            try {
                return iConverters.convert(parameterType, paramterName, context, result, sequence);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        Converters.registerConverters(new ContextConvert());
        Converters.registerConverters(new RequestConvert());
        Converters.registerConverters(new ResponseConvert());
        Converters.registerConverters(new RendererConvert());
        Converters.registerConverters(new JSONObjectConvert());
        Converters.registerConverters(new PathVariableConvert());
    }
}

