/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Qualifier;
import org.b3log.latke.ioc.inject.Scope;
import org.b3log.latke.ioc.inject.Singleton;
import org.b3log.latke.ioc.inject.Stereotype;
import org.b3log.latke.ioc.literal.NamedLiteral;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Reflections;
import org.b3log.latke.util.Strings;

public final class Beans {
    private static final Logger LOGGER = Logger.getLogger(Beans.class);

    private Beans() {
    }

    public static Set<Annotation> getQualifiers(Class<?> clazz, String beanName) {
        Annotation[] annotations = clazz.getAnnotations();
        Set<Annotation> qualifierAnnotations = CollectionUtils.arrayToSet(annotations);
        Set<Annotation> ret = Beans.selectQualifiers(qualifierAnnotations);
        if (ret == null) {
            ret = new HashSet<Annotation>();
        }
        if (!Beans.hasNamedQualifier(clazz)) {
            ret.add(new NamedLiteral(beanName));
        }
        return ret;
    }

    public static Annotation selectNamedQualifier(Set<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Named.class)) continue;
            return annotation;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Annotation> selectQualifiers(Set<Annotation> annotations) {
        Set<Annotation> ret = Beans.getAnnotations(annotations, Qualifier.class);
        Annotation named = Beans.selectNamedQualifier(annotations);
        if (ret.isEmpty()) {
            if (named == null) return null;
            ret.add(named);
            return ret;
        } else {
            if (named == null) return ret;
            ret.add(named);
        }
        return ret;
    }

    public static final boolean containNamed(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            return true;
        }
        return false;
    }

    public static Class<? extends Annotation> getScope(Class<?> clazz) {
        Set<Annotation> annotations = CollectionUtils.arrayToSet(clazz.getAnnotations());
        Set<Annotation> ret = Beans.getAnnotations(annotations, Scope.class);
        if (!ret.isEmpty() && ret.size() != 1) {
            throw new RuntimeException("A bean class can only has one scope!");
        }
        return ret.isEmpty() ? Singleton.class : ret.iterator().next().annotationType();
    }

    public static Set<Class<? extends Annotation>> getStereotypes(Class<?> clazz) {
        HashSet<Class<? extends Annotation>> ret = new HashSet<Class<? extends Annotation>>();
        Set<Annotation> annotations = Beans.getAnnotations(CollectionUtils.arrayToSet(clazz.getAnnotations()), Stereotype.class);
        if (annotations.isEmpty()) {
            return ret;
        }
        for (Annotation annotation : annotations) {
            ret.add(annotation.annotationType());
        }
        return ret;
    }

    public static final boolean hasNamedQualifier(Class<?> clazz) {
        Set<Annotation> annotations = CollectionUtils.arrayToSet(clazz.getAnnotations());
        Set<Annotation> qualifiers = Beans.selectQualifiers(annotations);
        if (qualifiers == null) {
            return false;
        }
        return Beans.containNamed(qualifiers);
    }

    public static final String getBeanName(Class<?> clazz) {
        String ret;
        if (clazz.isAnnotationPresent(Named.class)) {
            ret = clazz.getAnnotation(Named.class).value();
        } else {
            String className = clazz.getSimpleName();
            LOGGER.log(Level.TRACE, "Class [name={0}, simpleName={1}]", clazz.getName(), className);
            if (Strings.isEmptyOrNull(className)) {
                return null;
            }
            ret = className.substring(0, 1).toLowerCase() + className.substring(1);
        }
        return ret;
    }

    public static boolean checkClass(Class<?> clazz) {
        return !Reflections.isAbstract(clazz) && !Reflections.isInterface(clazz);
    }

    public static final <T> Set<Type> getBeanTypes(Class<T> beanClass) {
        HashSet<Type> ret = new HashSet<Type>();
        ret.add(beanClass);
        Type genericSuperclass = beanClass;
        while (genericSuperclass != Object.class) {
            Type[] genericInterfaces = null;
            if (genericSuperclass instanceof Class) {
                genericInterfaces = genericSuperclass.getGenericInterfaces();
                genericSuperclass = genericSuperclass.getGenericSuperclass();
            } else if (genericSuperclass instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)genericSuperclass).getRawType();
                genericInterfaces = ((Class)rawType).getGenericInterfaces();
                genericSuperclass = ((Class)rawType).getGenericSuperclass();
            }
            if (genericSuperclass != Object.class) {
                ret.add(genericSuperclass);
            }
            if (null == genericInterfaces || 0 == genericInterfaces.length) continue;
            for (Type genericInterface : genericInterfaces) {
                ret.add(genericInterface);
                ret.addAll(Beans.getInterfaces((Class)genericInterface));
            }
        }
        return ret;
    }

    private static final <T> Set<Type> getInterfaces(Class<T> interfaceClass) {
        HashSet<Type> ret = new HashSet<Type>();
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        if (interfaces.length == 0) {
            return ret;
        }
        for (Class<?> i : interfaces) {
            ret.add(i);
            ret.addAll(Beans.getInterfaces(i));
        }
        return ret;
    }

    public static final Set<Class<? extends Annotation>> toAnnotationTypes(Set<Annotation> annotations) {
        HashSet<Class<? extends Annotation>> ret = new HashSet<Class<? extends Annotation>>();
        for (Annotation beanQualifier : annotations) {
            ret.add(beanQualifier.annotationType());
        }
        return ret.isEmpty() ? null : ret;
    }

    private static Set<Annotation> getAnnotations(Set<Annotation> annotations, Class<? extends Annotation> neededAnnotationType) {
        HashSet<Annotation> ret = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            Annotation[] metaAnnotations;
            annotation.annotationType().getAnnotations();
            for (Annotation metaAnnotation : metaAnnotations = annotation.annotationType().getAnnotations()) {
                if (!metaAnnotation.annotationType().equals(neededAnnotationType)) continue;
                ret.add(annotation);
            }
        }
        return ret;
    }
}

