/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.mock;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class MockServletContext
implements ServletContext {
    private static final Logger LOGGER = Logger.getLogger(MockServletContext.class);
    private File webappRoot;
    private File webInfRoot;
    private File webInfClassesRoot;

    public MockServletContext() {
        try {
            URL webxml = this.getClass().getResource("/WEB-INF/web.xml");
            if (webxml != null) {
                this.webInfRoot = new File(webxml.toURI()).getParentFile();
                LOGGER.trace("WEB-INF: " + this.webInfRoot.getAbsolutePath());
                if (this.webInfRoot != null) {
                    this.webInfClassesRoot = new File(this.webInfRoot.getParentFile().getPath());
                    LOGGER.trace("WEB-INF/classes: " + this.webInfClassesRoot.getAbsolutePath());
                    this.webappRoot = this.webInfRoot.getParentFile();
                    LOGGER.trace("Web app root: " + this.webappRoot.getAbsolutePath());
                }
            } else {
                this.webappRoot = new File(this.getClass().getResource("/").toURI());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Unable to find web.xml, ignores this exception if you are running with a servlet container", e);
        }
    }

    public String getContextPath() {
        return "";
    }

    public ServletContext getContext(String uripath) {
        throw new UnsupportedOperationException("Not supported yet [getContext]");
    }

    public int getMajorVersion() {
        throw new UnsupportedOperationException("Not supported yet [getMajorVersion]");
    }

    public int getMinorVersion() {
        throw new UnsupportedOperationException("Not supported yet [getMinorVersion]");
    }

    public String getMimeType(String file) {
        throw new UnsupportedOperationException("Not supported yet [getMimeType]");
    }

    public Set getResourcePaths(String path) {
        return Collections.emptySet();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getClass().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not supported yet [getRequestDispatcher]");
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException("Not supported yet [getNamedDispatcher]");
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet [getServlet]");
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException("Not supported yet [getServlets]");
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException("Not supported yet [getServletNames]");
    }

    public void log(String msg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void log(Exception exception, String msg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void log(String message, Throwable throwable) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRealPath(String path) {
        if (this.webappRoot != null) {
            return this.webappRoot.getAbsolutePath() + path;
        }
        return path;
    }

    public String getServerInfo() {
        throw new UnsupportedOperationException("Not supported yet [getServerInfo]");
    }

    public String getInitParameter(String name) {
        throw new UnsupportedOperationException("Not supported yet [getInitParameter]");
    }

    public Enumeration getInitParameterNames() {
        throw new UnsupportedOperationException("Not supported yet [getInitParameterNames]");
    }

    public Object getAttribute(String name) {
        throw new UnsupportedOperationException("Not supported yet [getAttribute]");
    }

    public Enumeration getAttributeNames() {
        throw new UnsupportedOperationException("Not supported yet [getAttributeNames]");
    }

    public void setAttribute(String name, Object object) {
        throw new UnsupportedOperationException("Not supported yet [setAttribute]");
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException("Not supported yet [removeAttribute]");
    }

    public String getServletContextName() {
        return "mock servlet cocntext name";
    }

    public int getEffectiveMajorVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getEffectiveMinorVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

