/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.context;

import java.util.HashMap;
import java.util.Map;
import org.b3log.latke.ioc.bean.Bean;
import org.b3log.latke.ioc.context.CreationalContext;

public class CreationalContextImpl<T>
implements CreationalContext<T> {
    private final Map<Bean<?>, Object> incompleteInstances;
    private final Bean<T> bean;
    private final boolean outer;

    public CreationalContextImpl(Bean<T> bean) {
        this.incompleteInstances = new HashMap();
        this.bean = bean;
        this.outer = true;
    }

    private CreationalContextImpl(Bean<T> bean, Map<Bean<?>, Object> incompleteInstances) {
        this.incompleteInstances = incompleteInstances;
        this.bean = bean;
        this.outer = false;
    }

    @Override
    public void push(T incompleteInstance) {
        this.incompleteInstances.put(this.bean, incompleteInstance);
    }

    public <S> CreationalContextImpl<S> getCreationalContext(Bean<S> bean) {
        return new CreationalContextImpl<S>(bean, new HashMap(this.incompleteInstances));
    }

    public <S> S getIncompleteInstance(Bean<S> bean) {
        return (S)this.incompleteInstances.get(bean);
    }

    public boolean containsIncompleteInstance(Bean<?> bean) {
        return this.incompleteInstances.containsKey(bean);
    }

    public boolean isOuter() {
        return this.outer;
    }

    @Override
    public void release() {
    }
}

