/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.LatkeBeanManagerImpl;
import org.b3log.latke.ioc.config.BeanModule;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.ioc.context.AbstractContext;
import org.b3log.latke.ioc.context.ApplicationContext;
import org.b3log.latke.ioc.context.ApplicationScoped;
import org.b3log.latke.ioc.context.Context;
import org.b3log.latke.ioc.context.RequestContext;
import org.b3log.latke.ioc.context.RequestScoped;
import org.b3log.latke.ioc.context.SessionContext;
import org.b3log.latke.ioc.context.SessionScoped;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class Lifecycle {
    private static final Logger LOGGER = Logger.getLogger(Lifecycle.class);
    private static LatkeBeanManager beanManager;
    private static Map<String, SessionContext> sessionContexts;
    private static ApplicationContext applicationContext;
    private static ThreadLocal<SessionContext> sessionContext;
    private static ThreadLocal<RequestContext> requestContext;

    private Lifecycle() {
    }

    public static void startApplication(Collection<Class<?>> classes, BeanModule ... beanModule) {
        LOGGER.log(Level.DEBUG, "Initializing Latke IoC container", new Object[0]);
        beanManager = LatkeBeanManagerImpl.getInstance();
        applicationContext.setActive(true);
        beanManager.addContext(applicationContext);
        Configurator configurator = beanManager.getConfigurator();
        if (null != classes && !classes.isEmpty()) {
            configurator.createBeans(classes);
        }
        if (null != beanModule && 0 < beanModule.length) {
            for (int i = 0; i < beanModule.length; ++i) {
                configurator.addModule(beanModule[i]);
            }
        }
        LOGGER.log(Level.DEBUG, "Initialized Latke IoC container", new Object[0]);
    }

    public static void endApplication() {
        Lifecycle.endSession();
        Lifecycle.endRequest();
        ApplicationContext applicationCxt = Lifecycle.getApplicationContext();
        applicationCxt.destroy();
        sessionContexts.clear();
        beanManager.clearContexts();
        LOGGER.log(Level.DEBUG, "Latke IoC container ended", new Object[0]);
    }

    public static void startSession(HttpSession httpSession) {
        String sessionId = httpSession.getId();
        SessionContext currentSessionContext = sessionContexts.get(sessionId);
        if (currentSessionContext == null) {
            currentSessionContext = new SessionContext();
            sessionContexts.put(sessionId, currentSessionContext);
        }
        currentSessionContext.setActive(true);
        sessionContext.set(currentSessionContext);
        beanManager.addContext(sessionContext.get());
        LOGGER.info("Session started!");
    }

    public static void endSession() {
        SessionContext sessionCxt = Lifecycle.getSessionContext();
        if (null == sessionCxt) {
            return;
        }
        sessionCxt.destroy();
        sessionContext.remove();
        LOGGER.info("Session ended!");
    }

    public static void startRequest(ServletRequestEvent servletRequestEvent) {
        HttpSession session;
        HttpServletRequest request;
        requestContext.set(new RequestContext());
        requestContext.get().setActive(true);
        if (servletRequestEvent != null && (request = (HttpServletRequest)servletRequestEvent.getServletRequest()) != null && (session = request.getSession(false)) != null) {
            Lifecycle.startSession(session);
        }
        LOGGER.info("Request started!");
    }

    public static void endRequest() {
        RequestContext requestCxt = Lifecycle.getRequestContext();
        if (null == requestCxt) {
            return;
        }
        requestCxt.destroy();
        requestContext.remove();
        LOGGER.info("Request ended!");
    }

    public static Context getCurrentContext(Class<? extends Annotation> scopeType) {
        AbstractContext ret = null;
        if (scopeType.equals(RequestScoped.class)) {
            ret = Lifecycle.getRequestContext();
        } else if (scopeType.equals(SessionScoped.class)) {
            ret = Lifecycle.getSessionContext();
        } else if (scopeType.equals(ApplicationScoped.class)) {
            ret = Lifecycle.getApplicationContext();
        }
        return ret;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static SessionContext getSessionContext() {
        return sessionContext.get();
    }

    public static RequestContext getRequestContext() {
        return requestContext.get();
    }

    public static LatkeBeanManager getBeanManager() {
        return beanManager;
    }

    static {
        sessionContexts = new ConcurrentHashMap<String, SessionContext>();
        applicationContext = new ApplicationContext();
        sessionContext = new ThreadLocal();
        requestContext = new ThreadLocal();
    }
}

