/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.annotated.AnnotatedType;
import org.b3log.latke.ioc.bean.Bean;
import org.b3log.latke.ioc.bean.LatkeBean;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.ioc.config.impl.ConfiguratorImpl;
import org.b3log.latke.ioc.context.Context;
import org.b3log.latke.ioc.context.ContextNotActiveException;
import org.b3log.latke.ioc.context.Contextual;
import org.b3log.latke.ioc.context.CreationalContext;
import org.b3log.latke.ioc.context.CreationalContextImpl;
import org.b3log.latke.ioc.context.SingletonContext;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Provider;
import org.b3log.latke.ioc.inject.Singleton;
import org.b3log.latke.ioc.point.InjectionPoint;
import org.b3log.latke.ioc.point.InjectionTarget;
import org.b3log.latke.ioc.util.Beans;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.plugin.PluginManager;
import org.b3log.latke.service.LangPropsServiceImpl;
import org.b3log.latke.servlet.advice.AfterRequestProcessAdvice;
import org.b3log.latke.servlet.advice.BeforeRequestProcessAdvice;
import org.b3log.latke.util.Reflections;

@Named(value="beanManager")
@Singleton
public class LatkeBeanManagerImpl
implements LatkeBeanManager {
    private static final Logger LOGGER = Logger.getLogger(LatkeBeanManagerImpl.class);
    private static Set<LatkeBean<?>> builtInBeans;
    private static List<Class<?>> builtInBeanClasses;
    private Configurator configurator;
    private Set<LatkeBean<?>> beans;
    private Map<Class<? extends Annotation>, Set<Context>> contexts;

    private LatkeBeanManagerImpl() {
        LOGGER.log(Level.DEBUG, "Creating Latke bean manager", new Object[0]);
        this.beans = new HashSet();
        this.contexts = new HashMap<Class<? extends Annotation>, Set<Context>>();
        builtInBeans = new HashSet();
        this.configurator = new ConfiguratorImpl(this);
        SingletonContext singletonContext = new SingletonContext();
        LatkeBean<LatkeBeanManagerImpl> beanManagerBean = this.configurator.createBean(LatkeBeanManagerImpl.class);
        singletonContext.add(beanManagerBean, this);
        singletonContext.setActive(true);
        this.addContext(singletonContext);
        for (Class<?> builtInBeanClass : builtInBeanClasses) {
            LatkeBean<?> builtInBean = this.configurator.createBean(builtInBeanClass);
            builtInBeans.add(builtInBean);
            singletonContext.get(builtInBean, new CreationalContextImpl(builtInBean));
        }
        this.beans.addAll(builtInBeans);
        LOGGER.log(Level.DEBUG, "Created Latke bean manager", new Object[0]);
    }

    public static LatkeBeanManager getInstance() {
        return BeanManagerHolder.instance;
    }

    @Override
    public void addBean(LatkeBean<?> bean) {
        this.beans.add(bean);
    }

    @Override
    public Set<LatkeBean<?>> getBeans() {
        return this.beans;
    }

    @Override
    public Set<LatkeBean<?>> getBeans(Class<? extends Annotation> stereoType) {
        HashSet ret = new HashSet();
        for (LatkeBean<?> bean : this.beans) {
            Set<Class<Annotation>> stereotypes = bean.getStereotypes();
            if (!stereotypes.contains(stereoType)) continue;
            ret.add(bean);
        }
        return ret;
    }

    @Override
    public <T> LatkeBean<T> getBean(Class<T> beanClass) {
        for (LatkeBean<?> bean : this.beans) {
            if (!bean.getBeanClass().equals(beanClass)) continue;
            return bean;
        }
        throw new RuntimeException("Can not get bean with class [" + beanClass.getName() + ']');
    }

    @Override
    public Configurator getConfigurator() {
        return this.configurator;
    }

    public Object getReference(Bean bean, Type beanType, CreationalContext ctx) {
        Context activeContext = this.getContext(bean.getScope());
        return activeContext.get(bean, ctx);
    }

    @Override
    public Object getInjectableReference(InjectionPoint ij, CreationalContext<?> ctx) {
        ParameterizedType parameterizedType;
        Type type;
        Type baseType = ij.getAnnotated().getBaseType();
        if (baseType instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)baseType).getRawType()).equals(Provider.class)) {
            return null;
        }
        Set<Annotation> requiredQualifiers = ij.getQualifiers();
        LatkeBean<?> bean = this.getBean(baseType, requiredQualifiers);
        Object ret = bean.getScope() != Singleton.class ? bean.create(null) : this.getReference(bean, baseType, (CreationalContext)ctx);
        return ret;
    }

    @Override
    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... qualifiers) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        HashSet ret = new HashSet();
        for (Bean bean : this.beans) {
            if (!bean.getName().equals(name)) continue;
            ret.add(bean);
        }
        return ret;
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void validate(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void fireEvent(Object event, Annotation ... qualifiers) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addContext(Context context) {
        Class<? extends Annotation> scope = context.getScope();
        Set<Context> contextSet = this.contexts.get(scope);
        if (contextSet == null) {
            contextSet = new HashSet<Context>();
        }
        contextSet.add(context);
        this.contexts.put(scope, contextSet);
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        Set<Context> contextSet = this.contexts.get(scopeType);
        HashSet<Context> ret = new HashSet<Context>();
        if (contextSet != null) {
            for (Context context : contextSet) {
                if (!context.isActive()) continue;
                ret.add(context);
            }
        }
        if (ret.isEmpty()) {
            throw new ContextNotActiveException("Has no active context for scope[name=" + scopeType.getName() + "]");
        }
        if (ret.size() > 1) {
            throw new IllegalArgumentException("There is more than one active context object for the given scope[name=" + scopeType.getName() + "]");
        }
        return (Context)ret.iterator().next();
    }

    @Override
    public void clearContexts() {
        this.contexts.clear();
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LatkeBean<?> getBean(Type beanType, Set<Annotation> qualifiers) {
        for (LatkeBean<?> bean : this.beans) {
            if (Reflections.isConcrete(beanType) && qualifiers.isEmpty() && bean.getBeanClass().equals((Class)beanType)) {
                return bean;
            }
            if (!bean.getTypes().contains(beanType)) continue;
            Set<Annotation> beanQualifiers = bean.getQualifiers();
            Annotation named = Beans.selectNamedQualifier(qualifiers);
            if (named == null) {
                if (!beanQualifiers.containsAll(qualifiers)) continue;
                return bean;
            }
            Annotation beanNamed = Beans.selectNamedQualifier(beanQualifiers);
            if (!(qualifiers.size() == 1 ? beanNamed.equals(named) : beanQualifiers.equals(qualifiers))) continue;
            return bean;
        }
        throw new RuntimeException("Not found bean[beanType=" + beanType + "]");
    }

    @Override
    public LatkeBean<?> getBean(String name) {
        Set<Bean<?>> ret = this.getBeans(name);
        if (null == ret) {
            return null;
        }
        if (0 == ret.size()) {
            return null;
        }
        if (1 == ret.size()) {
            return (LatkeBean)ret.iterator().next();
        }
        throw new RuntimeException("Ambiguous resolution by name!");
    }

    @Override
    public Object getReference(LatkeBean<?> bean, CreationalContext<?> creationalContext) {
        return this.getReference(bean, (Type)null, (CreationalContext)creationalContext);
    }

    @Override
    public <T> T getReference(LatkeBean<T> bean) {
        return (T)this.getReference(bean, new CreationalContextImpl<T>(bean));
    }

    @Override
    public <T> T getReference(Class<T> beanClass) {
        LatkeBean<T> bean = this.getBean(beanClass);
        return this.getReference(bean);
    }

    static {
        builtInBeanClasses = Arrays.asList(LangPropsServiceImpl.class, BeforeRequestProcessAdvice.class, AfterRequestProcessAdvice.class, EventManager.class, PluginManager.class);
    }

    private static final class BeanManagerHolder {
        private static LatkeBeanManager instance = new LatkeBeanManagerImpl();

        private BeanManagerHolder() {
        }
    }
}

