/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.image;

import org.b3log.latke.image.ImageService;
import org.b3log.latke.logging.Logger;

public final class ImageServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(ImageServiceFactory.class);
    private static final ImageService IMAGE_SERVICE;

    private ImageServiceFactory() {
    }

    public static ImageService getImageService() {
        return IMAGE_SERVICE;
    }

    static {
        LOGGER.info("Constructing image service....");
        try {
            Class<?> serviceClass = Class.forName("org.b3log.latke.image.local.LocalImageService");
            IMAGE_SERVICE = (ImageService)serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize image service!", e);
        }
        LOGGER.info("Constructed image service");
    }
}

