/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.util.Strings;

public final class Stopwatchs {
    private static final ThreadLocal<Stopwatch> STOPWATCH = new ThreadLocal();

    public static void start(String taskTitle) {
        Stopwatch root = STOPWATCH.get();
        if (null == root) {
            root = new Stopwatch(taskTitle);
            STOPWATCH.set(root);
            return;
        }
        Stopwatch recent = Stopwatchs.getRecentRunning(STOPWATCH.get());
        if (null == recent) {
            return;
        }
        recent.addLeaf(new Stopwatch(taskTitle));
    }

    public static void end() {
        Stopwatch root = STOPWATCH.get();
        if (null == root) {
            return;
        }
        Stopwatch recent = Stopwatchs.getRecentRunning(root);
        if (null == recent) {
            return;
        }
        recent.setEndTime(System.currentTimeMillis());
    }

    public static void release() {
        STOPWATCH.set(null);
    }

    public static String getTimingStat() {
        Stopwatch root = STOPWATCH.get();
        if (null == root) {
            return "No stopwatch";
        }
        StringBuilder stringBuilder = new StringBuilder();
        root.appendTimingStat(1, stringBuilder);
        return stringBuilder.toString();
    }

    public static long getElapsed(String taskTitle) {
        long currentTimeMillis = System.currentTimeMillis();
        if (StringUtils.isBlank((String)taskTitle)) {
            return -1L;
        }
        Stopwatch root = STOPWATCH.get();
        if (null == root) {
            return -1L;
        }
        Stopwatch stopwatch = Stopwatchs.get(root, taskTitle);
        if (null == stopwatch) {
            return -1L;
        }
        if (stopwatch.isEnded()) {
            return stopwatch.getElapsedTime();
        }
        return currentTimeMillis - stopwatch.getStartTime();
    }

    private static Stopwatch get(Stopwatch parent, String taskTitle) {
        if (taskTitle.equals(parent.getTaskTitle())) {
            return parent;
        }
        for (Stopwatch leaf : parent.getLeaves()) {
            Stopwatch ret = Stopwatchs.get(leaf, taskTitle);
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    private static Stopwatch getRecentRunning(Stopwatch parent) {
        if (null == parent) {
            return null;
        }
        List<Stopwatch> leaves = parent.getLeaves();
        if (leaves.isEmpty()) {
            if (parent.isRunning()) {
                return parent;
            }
            return null;
        }
        for (int i = leaves.size() - 1; i > -1; --i) {
            Stopwatch leaf = leaves.get(i);
            if (!leaf.isRunning()) continue;
            return Stopwatchs.getRecentRunning(leaf);
        }
        return parent;
    }

    private Stopwatchs() {
    }

    private static class Stopwatch {
        private String taskTitle;
        private List<Stopwatch> leaves = new ArrayList<Stopwatch>();
        private long startTime;
        private long endTime;
        private static final int HUNDRED = 100;
        private static final MathContext MATH_CONTEXT = new MathContext(4, RoundingMode.HALF_UP);

        Stopwatch(String taskTitle) {
            this.taskTitle = taskTitle;
            this.startTime = System.currentTimeMillis();
        }

        public boolean isEnded() {
            return this.endTime > 0L;
        }

        public boolean isRunning() {
            return 0L == this.endTime;
        }

        public String getTaskTitle() {
            return this.taskTitle;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public List<Stopwatch> getLeaves() {
            return Collections.unmodifiableList(this.leaves);
        }

        public void addLeaf(Stopwatch leaf) {
            this.leaves.add(leaf);
        }

        public long getElapsedTime() {
            return this.endTime - this.startTime;
        }

        public float getPercentOfRoot() {
            Stopwatch root = (Stopwatch)STOPWATCH.get();
            if (null == root) {
                return 0.0f;
            }
            float rootElapsedTime = root.getElapsedTime();
            if (0.0f == rootElapsedTime) {
                return 0.0f;
            }
            return (float)this.getElapsedTime() / rootElapsedTime * 100.0f;
        }

        private void appendTimingStat(int level, StringBuilder stringBuilder) {
            stringBuilder.append(this.toString());
            for (int i = 0; i < this.leaves.size(); ++i) {
                Stopwatch leaf = this.leaves.get(i);
                stringBuilder.append(this.getIndentBlanks(level * 2));
                leaf.appendTimingStat(level + 1, stringBuilder);
            }
        }

        private String getIndentBlanks(int num) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < num; ++i) {
                builder.append(' ');
            }
            return builder.toString();
        }

        public String toString() {
            float percentOfRoot = this.getPercentOfRoot();
            if (0.0f > percentOfRoot) {
                percentOfRoot = 0.0f;
            }
            BigDecimal percenOfRoot = new BigDecimal(percentOfRoot, MATH_CONTEXT);
            StringBuilder stringBuilder = new StringBuilder("[").append(percenOfRoot).append("]%, [").append(this.getElapsedTime()).append("]ms [").append(this.getTaskTitle()).append("]").append(Strings.LINE_SEPARATOR);
            return stringBuilder.toString();
        }
    }
}

