/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.user.local;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.user.GeneralUser;
import org.b3log.latke.user.UserService;
import org.b3log.latke.util.Sessions;
import org.json.JSONObject;

public final class LocalUserService
implements UserService {
    private static final Logger LOGGER = Logger.getLogger(LocalUserService.class.getName());

    @Override
    public GeneralUser getCurrentUser(HttpServletRequest request) {
        JSONObject currentUser = Sessions.currentUser(request);
        if (null == currentUser) {
            return null;
        }
        GeneralUser ret = new GeneralUser();
        ret.setEmail(currentUser.optString("userEmail"));
        ret.setId(currentUser.optString(Keys.OBJECT_ID));
        ret.setNickname(currentUser.optString("userName"));
        return ret;
    }

    @Override
    public boolean isUserLoggedIn(HttpServletRequest request) {
        return null != Sessions.currentUser(request);
    }

    @Override
    public boolean isUserAdmin(HttpServletRequest request) {
        JSONObject currentUser = Sessions.currentUser(request);
        if (null == currentUser) {
            return false;
        }
        return "adminRole".equals(currentUser.optString("userRole"));
    }

    @Override
    public String createLoginURL(String destinationURL) {
        String to = Latkes.getServePath();
        try {
            to = URLEncoder.encode(to + destinationURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.ERROR, "URL encode[string={0}]", destinationURL);
        }
        return Latkes.getContextPath() + "/login?goto=" + to;
    }

    @Override
    public String createLogoutURL(String destinationURL) {
        String to = Latkes.getServePath();
        try {
            to = URLEncoder.encode(to + destinationURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.ERROR, "URL encode[string={0}]", destinationURL);
        }
        return Latkes.getContextPath() + "/logout?goto=" + to;
    }
}

