/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.user;

import org.b3log.latke.logging.Logger;
import org.b3log.latke.user.UserService;

public final class UserServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(UserServiceFactory.class);
    private static final UserService USER_SERVICE;

    private UserServiceFactory() {
    }

    public static UserService getUserService() {
        return USER_SERVICE;
    }

    static {
        LOGGER.info("Constructing user service....");
        try {
            Class<?> serviceClass = Class.forName("org.b3log.latke.user.local.LocalUserService");
            USER_SERVICE = (UserService)serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize user service!", e);
        }
        LOGGER.info("Constructed user service");
    }
}

