/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch.local;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.urlfetch.HTTPRequest;
import org.b3log.latke.urlfetch.HTTPResponse;
import org.b3log.latke.urlfetch.URLFetchService;
import org.b3log.latke.urlfetch.local.UrlFetchHandlerFactory;

public final class LocalURLFetchService
implements URLFetchService {
    private static final Logger LOGGER = Logger.getLogger(LocalURLFetchService.class);

    @Override
    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        HTTPRequestMethod requestMethod = request.getRequestMethod();
        if (requestMethod == null) {
            throw new IOException("RequestMethod  for URLFetch should not be null");
        }
        return UrlFetchHandlerFactory.getFetchHandler(requestMethod).doFetch(request);
    }

    @Override
    public Future<?> fetchAsync(HTTPRequest request) {
        FetchTask ret = new FetchTask(() -> {
            LOGGER.log(Level.DEBUG, "Fetch async, request=[" + request.toString() + "]", new Object[0]);
            return this.fetch(request);
        }, request);
        Latkes.EXECUTOR_SERVICE.submit(ret);
        return ret;
    }

    private static class FetchTask
    extends FutureTask<HTTPResponse> {
        private HTTPRequest request;

        FetchTask(Callable<HTTPResponse> callable, HTTPRequest request) {
            super(callable);
            this.request = request;
        }

        @Override
        public String toString() {
            return "URL Fetch [request=" + this.request.toString() + "]";
        }
    }
}

