/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.urlfetch;

import org.b3log.latke.logging.Logger;
import org.b3log.latke.urlfetch.URLFetchService;

public final class URLFetchServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(URLFetchServiceFactory.class);
    private static final URLFetchService URL_FETCH_SERVICE;

    private URLFetchServiceFactory() {
    }

    public static URLFetchService getURLFetchService() {
        return URL_FETCH_SERVICE;
    }

    static {
        LOGGER.info("Constructing URL fetch service....");
        try {
            Class<?> serviceClass = Class.forName("org.b3log.latke.urlfetch.local.LocalURLFetchService");
            URL_FETCH_SERVICE = (URLFetchService)serviceClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize URL fetch service!", e);
        }
        LOGGER.info("Constructed URL fetch service");
    }
}

