/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.image.Image;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;

public final class PNGRenderer
extends AbstractHTTPResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(PNGRenderer.class.getName());
    private Image image;

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public void render(HTTPRequestContext context) {
        try {
            HttpServletResponse response = context.getResponse();
            response.setContentType("image/png");
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(this.image.getData());
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Render failed", e);
        }
    }
}

