/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet.renderer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;

public final class AtomRenderer
extends AbstractHTTPResponseRenderer {
    private static final Logger LOGGER = Logger.getLogger(AtomRenderer.class.getName());
    private String content;

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void render(HTTPRequestContext context) {
        try {
            HttpServletResponse response = context.getResponse();
            response.setContentType("application/atom+xml");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(this.content);
            writer.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Render failed", e);
        }
    }
}

