/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HttpControl;
import org.b3log.latke.servlet.handler.AdviceHandler;
import org.b3log.latke.servlet.handler.ArgsHandler;
import org.b3log.latke.servlet.handler.Handler;
import org.b3log.latke.servlet.handler.MethodInvokeHandler;
import org.b3log.latke.servlet.handler.RequestDispatchHandler;
import org.b3log.latke.servlet.handler.RequestPrepareHandler;
import org.b3log.latke.servlet.handler.StaticResourceHandler;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.HTTP404Renderer;
import org.b3log.latke.servlet.renderer.HTTP500Renderer;

public final class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DispatcherServlet.class);
    public static final List<Handler> SYS_HANDLER = new ArrayList<Handler>();

    public void init() throws ServletException {
        SYS_HANDLER.add(new StaticResourceHandler(this.getServletContext()));
        SYS_HANDLER.add(new RequestPrepareHandler());
        SYS_HANDLER.add(new RequestDispatchHandler());
        SYS_HANDLER.add(new ArgsHandler());
        SYS_HANDLER.add(new AdviceHandler());
        SYS_HANDLER.add(new MethodInvokeHandler());
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HTTPRequestContext httpRequestContext = new HTTPRequestContext();
        httpRequestContext.setRequest(req);
        httpRequestContext.setResponse(resp);
        HttpControl httpControl = new HttpControl(SYS_HANDLER.iterator(), httpRequestContext);
        try {
            httpControl.nextHandler();
        }
        catch (Exception e) {
            httpRequestContext.setRenderer(new HTTP500Renderer(e));
        }
        DispatcherServlet.result(httpRequestContext);
    }

    public static void result(HTTPRequestContext context) throws IOException {
        HttpServletResponse response = context.getResponse();
        if (response.isCommitted()) {
            return;
        }
        AbstractHTTPResponseRenderer renderer = context.getRenderer();
        if (null == renderer) {
            renderer = new HTTP404Renderer();
        }
        renderer.render(context);
    }
}

