/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcUtil {
    private static final Logger LOGGER = Logger.getLogger(JdbcUtil.class);

    public static boolean executeSql(String sql, Connection connection) throws SQLException {
        LOGGER.log(Level.TRACE, "executeSql: {0}", sql);
        Statement statement = connection.createStatement();
        boolean isSuccess = !statement.execute(sql);
        statement.close();
        return isSuccess;
    }

    public static boolean executeSql(String sql, List<Object> paramList, Connection connection) throws SQLException {
        LOGGER.log(Level.TRACE, "Execute SQL [{0}]", sql);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        boolean isSuccess = preparedStatement.execute();
        preparedStatement.close();
        return isSuccess;
    }

    public static JSONObject queryJsonObject(String sql, List<Object> paramList, Connection connection, String tableName) throws SQLException, JSONException, RepositoryException {
        return JdbcUtil.queryJson(sql, paramList, connection, true, tableName);
    }

    public static JSONArray queryJsonArray(String sql, List<Object> paramList, Connection connection, String tableName) throws SQLException, JSONException, RepositoryException {
        JSONObject jsonObject = JdbcUtil.queryJson(sql, paramList, connection, false, tableName);
        return jsonObject.getJSONArray("rslts");
    }

    private static JSONObject queryJson(String sql, List<Object> paramList, Connection connection, boolean ifOnlyOne, String tableName) throws SQLException, JSONException, RepositoryException {
        LOGGER.log(Level.TRACE, "Query SQL [{0}]", sql);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        for (int i = 1; i <= paramList.size(); ++i) {
            preparedStatement.setObject(i, paramList.get(i - 1));
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        JSONObject jsonObject = JdbcUtil.resultSetToJsonObject(resultSet, ifOnlyOne, tableName);
        resultSet.close();
        preparedStatement.close();
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject resultSetToJsonObject(ResultSet resultSet, boolean ifOnlyOne, String tableName) throws SQLException, JSONException, RepositoryException {
        JSONObject jsonObject;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        List<FieldDefinition> definitionList = JdbcRepositories.getRepositoriesMap().get(tableName);
        if (definitionList == null) {
            LOGGER.log(Level.ERROR, "resultSetToJsonObject: null definitionList finded for table  {0}", tableName);
            throw new RepositoryException("resultSetToJsonObject: null definitionList finded for table  " + tableName);
        }
        HashMap<String, FieldDefinition> dMap = new HashMap<String, FieldDefinition>();
        for (FieldDefinition fieldDefinition : definitionList) {
            if (Latkes.RuntimeDatabase.H2 == Latkes.getRuntimeDatabase()) {
                dMap.put(fieldDefinition.getName().toUpperCase(), fieldDefinition);
                continue;
            }
            dMap.put(fieldDefinition.getName(), fieldDefinition);
        }
        int numColumns = resultSetMetaData.getColumnCount();
        JSONArray jsonArray = new JSONArray();
        while (resultSet.next()) {
            jsonObject = new JSONObject();
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = resultSetMetaData.getColumnName(i);
                FieldDefinition definition = (FieldDefinition)dMap.get(columnName);
                if (definition == null) {
                    jsonObject.put(columnName, resultSet.getObject(columnName));
                    continue;
                }
                if ("boolean".equals(definition.getType())) {
                    jsonObject.put(definition.getName(), resultSet.getBoolean(columnName));
                    continue;
                }
                Object v = resultSet.getObject(columnName);
                if (v instanceof Clob) {
                    Clob clob = (Clob)v;
                    String str = null;
                    try {
                        str = IOUtils.toString((Reader)clob.getCharacterStream());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.ERROR, "Cant not read column[name=" + columnName + "] in table[name=" + tableName + "] on H2", e);
                    }
                    finally {
                        try {
                            clob.free();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.ERROR, "clob.free error", e);
                        }
                    }
                    jsonObject.put(definition.getName(), str);
                    continue;
                }
                jsonObject.put(definition.getName(), v);
            }
            jsonArray.put(jsonObject);
        }
        if (ifOnlyOne) {
            if (jsonArray.length() > 0) {
                jsonObject = jsonArray.getJSONObject(0);
                return jsonObject;
            }
            return null;
        }
        jsonObject = new JSONObject();
        jsonObject.put("rslts", jsonArray);
        return jsonObject;
    }

    private JdbcUtil() {
    }
}

