/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Callstacks;
import org.h2.jdbcx.JdbcConnectionPool;

public final class Connections {
    private static final Logger LOGGER = Logger.getLogger(Connections.class.getName());
    private static String poolType;
    private static final int CONN_TIMEOUT = 5000;
    private static JdbcConnectionPool h2;
    private static DruidDataSource druid;
    private static String transactionIsolation;
    private static int transactionIsolationInt;
    private static String url;
    private static String userName;
    private static String password;

    public static Connection getConnection() throws SQLException {
        if (LOGGER.isTraceEnabled()) {
            Callstacks.printCallstack(Level.TRACE, new String[]{"org.b3log"}, null);
        }
        if ("h2".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[leasedConns={0}]", h2.getActiveConnections());
            Connection ret = h2.getConnection();
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if ("druid".equals(poolType)) {
            LOGGER.log(Level.TRACE, "Connection pool[leasedConns={0}]", druid.getActiveConnections());
            DruidPooledConnection ret = druid.getConnection();
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if ("none".equals(poolType)) {
            Connection ret = DriverManager.getConnection(url, userName, password);
            ret.setTransactionIsolation(transactionIsolationInt);
            ret.setAutoCommit(false);
            return ret;
        }
        if (Latkes.RuntimeDatabase.NONE == Latkes.getRuntimeDatabase()) {
            return null;
        }
        throw new IllegalStateException("Not found database connection pool [" + poolType + "]");
    }

    public static void shutdownConnectionPool() {
        if (null != h2) {
            h2.dispose();
            LOGGER.info("Closed [H2] database connection pool");
        }
        if (null != druid) {
            druid.close();
            LOGGER.info("Closed [druid] database connection pool");
        }
    }

    private Connections() {
    }

    static {
        try {
            if (Latkes.RuntimeDatabase.NONE != Latkes.getRuntimeDatabase()) {
                String driver = Latkes.getLocalProperty("jdbc.driver");
                Class.forName(driver);
                poolType = Latkes.getLocalProperty("jdbc.pool");
                url = Latkes.getLocalProperty("jdbc.URL");
                userName = Latkes.getLocalProperty("jdbc.username");
                password = Latkes.getLocalProperty("jdbc.password");
                int minConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.minConnCnt"));
                int maxConnCnt = Integer.valueOf(Latkes.getLocalProperty("jdbc.maxConnCnt"));
                transactionIsolation = Latkes.getLocalProperty("jdbc.transactionIsolation");
                if ("NONE".equals(transactionIsolation)) {
                    transactionIsolationInt = 0;
                } else if ("READ_COMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 2;
                } else if ("READ_UNCOMMITTED".equals(transactionIsolation)) {
                    transactionIsolationInt = 1;
                } else if ("REPEATABLE_READ".equals(transactionIsolation)) {
                    transactionIsolationInt = 4;
                } else if ("SERIALIZABLE".equals(transactionIsolation)) {
                    transactionIsolationInt = 8;
                } else {
                    throw new IllegalStateException("Undefined transaction isolation [" + transactionIsolation + ']');
                }
                if ("h2".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initialing database connection pool [h2]", new Object[0]);
                    h2 = JdbcConnectionPool.create((String)url, (String)userName, (String)password);
                    h2.setMaxConnections(maxConnCnt);
                } else if ("druid".equals(poolType)) {
                    LOGGER.log(Level.DEBUG, "Initialing database connection pool [druid]", new Object[0]);
                    Properties props = new Properties();
                    InputStream is = Connections.class.getResourceAsStream("/druid.properties");
                    if (null != is) {
                        props.load(is);
                        druid = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
                    } else {
                        druid = new DruidDataSource();
                        druid.setTestOnReturn(true);
                        druid.setTestOnBorrow(false);
                        druid.setTestWhileIdle(true);
                        druid.setValidationQuery("SELECT 1");
                        druid.setMaxWait(5000L);
                        druid.setValidationQueryTimeout(5000);
                    }
                    druid.setUsername(userName);
                    druid.setPassword(password);
                    druid.setUrl(url);
                    druid.setDriverClassName(driver);
                    druid.setInitialSize(minConnCnt);
                    druid.setMinIdle(minConnCnt);
                    druid.setMaxActive(maxConnCnt);
                } else if ("none".equals(poolType)) {
                    LOGGER.info("Do not use database connection pool");
                }
                LOGGER.info("Initialized connection pool [type=" + poolType + ']');
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not initialize database connection", e);
        }
    }
}

