/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.JDBCRepositoryException;
import org.b3log.latke.util.Callstacks;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractRepository
implements Repository {
    private static final Logger LOGGER = Logger.getLogger(AbstractRepository.class);
    private Repository repository;

    public AbstractRepository(String name) {
        try {
            Class<?> repositoryClass;
            Latkes.RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
            switch (runtimeDatabase) {
                case MYSQL: 
                case H2: 
                case MSSQL: {
                    repositoryClass = Class.forName("org.b3log.latke.repository.jdbc.JdbcRepository");
                    break;
                }
                case NONE: {
                    repositoryClass = Class.forName("org.b3log.latke.repository.NoneRepository");
                    break;
                }
                default: {
                    throw new RuntimeException("The runtime database [" + (Object)((Object)runtimeDatabase) + "] is not support NOW!");
                }
            }
            Constructor<?> constructor = repositoryClass.getConstructor(String.class);
            this.repository = (Repository)constructor.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize repository!", e);
        }
        Repositories.addRepository(this.repository);
        LOGGER.log(Level.INFO, "Constructed repository[name={0}]", name);
    }

    private static boolean isInternalCall() {
        return Callstacks.isCaller("org.b3log.latke.remote.RepositoryAccessor", "*");
    }

    @Override
    public String add(JSONObject jsonObject) throws RepositoryException {
        if (!this.isWritable() && !AbstractRepository.isInternalCall()) {
            throw new RepositoryException("The repository[name=" + this.getName() + "] is not writable at present");
        }
        Repositories.check(this.getName(), jsonObject, Keys.OBJECT_ID);
        return this.repository.add(jsonObject);
    }

    @Override
    public void update(String id, JSONObject jsonObject) throws RepositoryException {
        if (!this.isWritable() && !AbstractRepository.isInternalCall()) {
            throw new RepositoryException("The repository[name=" + this.getName() + "] is not writable at present");
        }
        Repositories.check(this.getName(), jsonObject, Keys.OBJECT_ID);
        this.repository.update(id, jsonObject);
    }

    @Override
    public void remove(String id) throws RepositoryException {
        if (!this.isWritable() && !AbstractRepository.isInternalCall()) {
            throw new RepositoryException("The repository[name=" + this.getName() + "] is not writable at present");
        }
        this.repository.remove(id);
    }

    @Override
    public JSONObject get(String id) throws RepositoryException {
        try {
            return this.repository.get(id);
        }
        catch (JDBCRepositoryException e) {
            LOGGER.log(Level.WARN, "SQL exception[msg={0}]", e.getMessage());
            return null;
        }
    }

    @Override
    public Map<String, JSONObject> get(Iterable<String> ids) throws RepositoryException {
        return this.repository.get(ids);
    }

    @Override
    public boolean has(String id) throws RepositoryException {
        return this.repository.has(id);
    }

    @Override
    public JSONObject get(Query query) throws RepositoryException {
        try {
            return this.repository.get(query);
        }
        catch (JDBCRepositoryException e) {
            LOGGER.log(Level.WARN, "SQL exception[msg={0}, repository={1}, query={2}]", e.getMessage(), this.repository.getName(), query.toString());
            JSONObject ret = new JSONObject();
            JSONObject pagination = new JSONObject();
            ret.put("pagination", pagination);
            pagination.put("paginationPageCount", 0);
            JSONArray results = new JSONArray();
            ret.put("rslts", results);
            return ret;
        }
    }

    @Override
    public List<JSONObject> select(String statement, Object ... params) throws RepositoryException {
        try {
            return this.repository.select(statement, params);
        }
        catch (JDBCRepositoryException e) {
            LOGGER.log(Level.WARN, "SQL exception[msg={0}, repository={1}, statement={2}]", e.getMessage(), this.repository.getName(), statement);
            return Collections.emptyList();
        }
    }

    @Override
    public List<JSONObject> getRandomly(int fetchSize) throws RepositoryException {
        return this.repository.getRandomly(fetchSize);
    }

    @Override
    public long count() throws RepositoryException {
        return this.repository.count();
    }

    @Override
    public long count(Query query) throws RepositoryException {
        return this.repository.count(query);
    }

    @Override
    public Transaction beginTransaction() {
        return this.repository.beginTransaction();
    }

    @Override
    public boolean hasTransactionBegun() {
        return this.repository.hasTransactionBegun();
    }

    @Override
    public String getName() {
        return this.repository.getName();
    }

    @Override
    public boolean isWritable() {
        return this.repository.isWritable();
    }

    @Override
    public void setWritable(boolean writable) {
        this.repository.setWritable(writable);
    }

    protected Repository getUnderlyingRepository() {
        return this.repository;
    }
}

