/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;

public abstract class AbstractEventQueue {
    private boolean changed = false;
    private Map<String, List<AbstractEventListener<?>>> listeners = new HashMap();

    synchronized void addListener(AbstractEventListener<?> listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        String eventType = listener.getEventType();
        if (null == eventType) {
            throw new NullPointerException();
        }
        List<AbstractEventListener<?>> listenerList = this.listeners.get(eventType);
        if (null == listenerList) {
            listenerList = new ArrayList();
            this.listeners.put(eventType, listenerList);
        }
        listenerList.add(listener);
    }

    synchronized void deleteListener(AbstractEventListener<?> listener) {
        String eventType = listener.getEventType();
        if (null == eventType) {
            throw new NullPointerException();
        }
        List<AbstractEventListener<?>> listenerList = this.listeners.get(eventType);
        if (null != listenerList) {
            listenerList.remove(listener);
        }
    }

    public void notifyListeners() throws EventException {
        this.notifyListeners(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(Event<?> event) throws EventException {
        AbstractEventListener[] arrLocal = null;
        AbstractEventQueue abstractEventQueue = this;
        synchronized (abstractEventQueue) {
            if (!this.changed) {
                return;
            }
            String eventType = event.getType();
            List<AbstractEventListener<?>> listenerList = this.listeners.get(eventType);
            AbstractEventListener[] types = new AbstractEventListener[1];
            if (null != listenerList && !listenerList.isEmpty()) {
                arrLocal = listenerList.toArray(types);
                this.clearChanged();
            }
        }
        if (null != arrLocal) {
            for (int i = arrLocal.length - 1; i >= 0; --i) {
                arrLocal[i].performAction(this, event);
            }
        }
    }

    public synchronized void deleteListeners() {
        this.listeners.clear();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countListeners() {
        return this.listeners.size();
    }
}

