/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.cache.redis.RedisCache;
import org.b3log.latke.cron.CronService;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.servlet.AbstractServletListener;
import org.b3log.latke.util.Strings;
import org.b3log.latke.util.freemarker.Templates;
import org.h2.tools.Server;

public final class Latkes {
    public static final ExecutorService EXECUTOR_SERVICE;
    private static final Logger LOGGER;
    private static final Properties LOCAL_PROPS;
    private static final Properties LATKE_PROPS;
    private static final Properties REMOTE_PROPS;
    private static Locale locale;
    private static RuntimeMode runtimeMode;
    private static String startupTimeMillis;
    private static String staticResourceVersion;
    private static String serverScheme;
    private static String staticServerScheme;
    private static String serverHost;
    private static String staticServerHost;
    private static String serverPort;
    private static String staticServerPort;
    private static String server;
    private static String servePath;
    private static String staticServer;
    private static String staticServePath;
    private static String contextPath;
    private static String staticPath;
    private static String scanPath;
    private static Server h2;

    private Latkes() {
    }

    public static String getStaticResourceVersion() {
        if (null == staticResourceVersion && null == (staticResourceVersion = LATKE_PROPS.getProperty("staticResourceVersion"))) {
            staticResourceVersion = startupTimeMillis;
        }
        return staticResourceVersion;
    }

    public static void setStaticResourceVersion(String staticResourceVersion) {
        Latkes.staticResourceVersion = staticResourceVersion;
    }

    public static String getServerScheme() {
        if (null == serverScheme && null == (serverScheme = LATKE_PROPS.getProperty("serverScheme"))) {
            throw new IllegalStateException("latke.properties [serverScheme] is empty");
        }
        return serverScheme;
    }

    public static void setServerScheme(String serverScheme) {
        Latkes.serverScheme = serverScheme;
    }

    public static String getServerHost() {
        if (null == serverHost && null == (serverHost = LATKE_PROPS.getProperty("serverHost"))) {
            throw new IllegalStateException("latke.properties [serverHost] is empty");
        }
        return serverHost;
    }

    public static void setServerHost(String serverHost) {
        Latkes.serverHost = serverHost;
    }

    public static String getServerPort() {
        if (null == serverPort) {
            serverPort = LATKE_PROPS.getProperty("serverPort");
        }
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        Latkes.serverPort = serverPort;
    }

    public static String getServer() {
        if (null == server) {
            StringBuilder serverBuilder = new StringBuilder(Latkes.getServerScheme()).append("://").append(Latkes.getServerHost());
            String port = Latkes.getServerPort();
            if (!Strings.isEmptyOrNull(port) && !port.equals("80")) {
                serverBuilder.append(':').append(port);
            }
            server = serverBuilder.toString();
        }
        return server;
    }

    public static String getServePath() {
        if (null == servePath) {
            servePath = Latkes.getServer() + Latkes.getContextPath();
        }
        return servePath;
    }

    public static String getStaticServerScheme() {
        if (null == staticServerScheme && null == (staticServerScheme = LATKE_PROPS.getProperty("staticServerScheme"))) {
            staticServerScheme = Latkes.getServerScheme();
        }
        return staticServerScheme;
    }

    public static void setStaticServerScheme(String staticServerScheme) {
        Latkes.staticServerScheme = staticServerScheme;
    }

    public static String getStaticServerHost() {
        if (null == staticServerHost && null == (staticServerHost = LATKE_PROPS.getProperty("staticServerHost"))) {
            staticServerHost = Latkes.getServerHost();
        }
        return staticServerHost;
    }

    public static void setStaticServerHost(String staticServerHost) {
        Latkes.staticServerHost = staticServerHost;
    }

    public static String getStaticServerPort() {
        if (null == staticServerPort && null == (staticServerPort = LATKE_PROPS.getProperty("staticServerPort"))) {
            staticServerPort = Latkes.getServerPort();
        }
        return staticServerPort;
    }

    public static void setStaticServerPort(String staticServerPort) {
        Latkes.staticServerPort = staticServerPort;
    }

    public static String getStaticServer() {
        if (null == staticServer) {
            StringBuilder staticServerBuilder = new StringBuilder(Latkes.getStaticServerScheme()).append("://").append(Latkes.getStaticServerHost());
            String port = Latkes.getStaticServerPort();
            if (!Strings.isEmptyOrNull(port) && !port.equals("80")) {
                staticServerBuilder.append(':').append(port);
            }
            staticServer = staticServerBuilder.toString();
        }
        return staticServer;
    }

    public static String getStaticServePath() {
        if (null == staticServePath) {
            staticServePath = Latkes.getStaticServer() + Latkes.getStaticPath();
        }
        return staticServePath;
    }

    public static String getContextPath() {
        if (null != contextPath) {
            return contextPath;
        }
        String contextPathConf = LATKE_PROPS.getProperty("contextPath");
        if (null != contextPathConf) {
            contextPath = contextPathConf;
            return contextPath;
        }
        ServletContext servletContext = AbstractServletListener.getServletContext();
        contextPath = servletContext.getContextPath();
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        Latkes.contextPath = contextPath;
    }

    public static String getStaticPath() {
        if (null == staticPath && null == (staticPath = LATKE_PROPS.getProperty("staticPath"))) {
            staticPath = Latkes.getContextPath();
        }
        return staticPath;
    }

    public static void setStaticPath(String staticPath) {
        Latkes.staticPath = staticPath;
    }

    public static String getScanPath() {
        if (null == scanPath) {
            scanPath = LATKE_PROPS.getProperty("scanPath");
        }
        return scanPath;
    }

    public static void setScanPath(String scanPath) {
        Latkes.scanPath = scanPath;
    }

    public static void initRuntimeEnv() {
        String newTCPServer;
        LOGGER.log(Level.TRACE, "Initializes runtime environment from configuration file", new Object[0]);
        if (null == runtimeMode) {
            String runtimeModeValue = LATKE_PROPS.getProperty("runtimeMode");
            if (null != runtimeModeValue) {
                runtimeMode = RuntimeMode.valueOf(runtimeModeValue);
            } else {
                LOGGER.log(Level.TRACE, "Can't parse runtime mode in latke.properties, default to [PRODUCTION]", new Object[0]);
                runtimeMode = RuntimeMode.PRODUCTION;
            }
        }
        LOGGER.log(Level.INFO, "Runtime mode is [{0}]", new Object[]{Latkes.getRuntimeMode()});
        RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
        LOGGER.log(Level.INFO, "Runtime database is [{0}]", new Object[]{runtimeDatabase});
        if (RuntimeDatabase.H2 == runtimeDatabase && "true".equals(newTCPServer = Latkes.getLocalProperty("newTCPServer"))) {
            LOGGER.log(Level.INFO, "Starting H2 TCP server", new Object[0]);
            String jdbcURL = Latkes.getLocalProperty("jdbc.URL");
            if (Strings.isEmptyOrNull(jdbcURL)) {
                throw new IllegalStateException("The jdbc.URL in local.properties is required");
            }
            String[] parts = jdbcURL.split(":");
            if (parts.length != Integer.valueOf("5")) {
                throw new IllegalStateException("jdbc.URL should like [jdbc:h2:tcp://localhost:8250/~/] (the port part is required)");
            }
            String port = parts[parts.length - 1];
            port = StringUtils.substringBefore((String)port, (String)"/");
            LOGGER.log(Level.TRACE, "H2 TCP port [{0}]", port);
            try {
                h2 = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-tcpAllowOthers"}).start();
            }
            catch (SQLException e) {
                String msg = "H2 TCP server create failed";
                LOGGER.log(Level.ERROR, "H2 TCP server create failed", e);
                throw new IllegalStateException("H2 TCP server create failed");
            }
            LOGGER.info("Started H2 TCP server");
        }
        RuntimeCache runtimeCache = Latkes.getRuntimeCache();
        LOGGER.log(Level.INFO, "Runtime cache is [{0}]", new Object[]{runtimeCache});
        locale = new Locale("en_US");
    }

    public static RuntimeMode getRuntimeMode() {
        if (null == runtimeMode) {
            throw new RuntimeException("Runtime mode has not been initialized!");
        }
        return runtimeMode;
    }

    public static void setRuntimeMode(RuntimeMode runtimeMode) {
        Latkes.runtimeMode = runtimeMode;
    }

    public static RuntimeCache getRuntimeCache() {
        String runtimeCache = LOCAL_PROPS.getProperty("runtimeCache");
        if (null == runtimeCache) {
            LOGGER.debug("Not found [runtimeCache] in local.properties, uses [LOCAL_LRU] as default");
            return RuntimeCache.LOCAL_LRU;
        }
        RuntimeCache ret = RuntimeCache.valueOf(runtimeCache);
        if (null == ret) {
            throw new RuntimeException("Please configures a valid runtime cache in local.properties!");
        }
        return ret;
    }

    public static RuntimeDatabase getRuntimeDatabase() {
        String runtimeDatabase = LOCAL_PROPS.getProperty("runtimeDatabase");
        if (null == runtimeDatabase) {
            throw new RuntimeException("Please configures runtime database in local.properties!");
        }
        RuntimeDatabase ret = RuntimeDatabase.valueOf(runtimeDatabase);
        if (null == ret) {
            throw new RuntimeException("Please configures a valid runtime database in local.properties!");
        }
        return ret;
    }

    public static Locale getLocale() {
        if (null == locale) {
            throw new RuntimeException("Default locale has not been initialized!");
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        Latkes.locale = locale;
    }

    public static String getLocalProperty(String key) {
        return LOCAL_PROPS.getProperty(key);
    }

    public static String getLatkeProperty(String key) {
        return LATKE_PROPS.getProperty(key);
    }

    public static boolean isRemoteEnabled() {
        return !REMOTE_PROPS.isEmpty();
    }

    public static String getRemoteProperty(String key) {
        return REMOTE_PROPS.getProperty(key);
    }

    public static void shutdown() {
        try {
            String newTCPServer;
            CronService.shutdown();
            EXECUTOR_SERVICE.shutdown();
            if (RuntimeCache.REDIS == Latkes.getRuntimeCache()) {
                RedisCache.shutdown();
            }
            Connections.shutdownConnectionPool();
            if (RuntimeDatabase.H2 == Latkes.getRuntimeDatabase() && "true".equals(newTCPServer = Latkes.getLocalProperty("newTCPServer"))) {
                h2.stop();
                h2.shutdown();
                LOGGER.log(Level.INFO, "Closed H2 TCP server", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdowns Latke failed", e);
        }
        Lifecycle.endApplication();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                LOGGER.log(Level.TRACE, "Unregistered JDBC driver [" + driver + "]", new Object[0]);
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Unregister JDBC driver [" + driver + "] failed", e);
            }
        }
    }

    public static void setTimeZone(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        Templates.MAIN_CFG.setTimeZone(timeZone);
        Templates.MOBILE_CFG.setTimeZone(timeZone);
    }

    public static void loadSkin(String skinDirName) {
        LOGGER.debug("Loading skin [dirName=" + skinDirName + ']');
        ServletContext servletContext = AbstractServletListener.getServletContext();
        Templates.MAIN_CFG.setServletContextForTemplateLoading((Object)servletContext, "skins/" + skinDirName);
        Latkes.setTimeZone("Asia/Shanghai");
        LOGGER.info("Loaded skins....");
    }

    public static String getSkinName(String skinDirName) {
        try {
            Properties ret = new Properties();
            File file = Latkes.getWebFile("/skins/" + skinDirName + "/skin.properties");
            ret.load(new FileInputStream(file));
            return ret.getProperty("name");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Read skin configuration error[msg={0}]", e.getMessage());
            return null;
        }
    }

    public static File getWebFile(String path) {
        ServletContext servletContext = AbstractServletListener.getServletContext();
        try {
            URL resource = servletContext.getResource(path);
            if (null == resource) {
                return null;
            }
            File ret = FileUtils.toFile((URL)resource);
            if (null == ret) {
                File tempdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                ret = new File(tempdir.getPath() + path);
                FileUtils.copyURLToFile((URL)resource, (File)ret);
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads file [path=" + path + "] failed", e);
            return null;
        }
    }

    static {
        InputStream resourceAsStream;
        EXECUTOR_SERVICE = Executors.newCachedThreadPool();
        LOGGER = Logger.getLogger(Latkes.class);
        LOCAL_PROPS = new Properties();
        LATKE_PROPS = new Properties();
        REMOTE_PROPS = new Properties();
        startupTimeMillis = String.valueOf(System.currentTimeMillis());
        LOGGER.debug("Loading latke.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/latke.properties");
            if (null != resourceAsStream) {
                LATKE_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded latke.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Not found latke.properties", new Object[0]);
            throw new RuntimeException("Not found latke.properties");
        }
        LOGGER.debug("Loading local.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/local.properties");
            if (null != resourceAsStream) {
                LOCAL_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded local.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Not found local.properties", new Object[0]);
        }
        LOGGER.debug("Loading remote.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/remote.properties");
            if (null != resourceAsStream) {
                REMOTE_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded remote.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Not found Latke remote.properties", new Object[0]);
        }
    }

    public static enum RuntimeMode {
        DEVELOPMENT,
        PRODUCTION;

    }

    public static enum RuntimeCache {
        NONE,
        LOCAL_LRU,
        REDIS;

    }

    public static enum RuntimeDatabase {
        NONE,
        ORACLE,
        MYSQL,
        H2,
        MSSQL;

    }
}

