/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantCP;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFieldref;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantMethodref;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.ObjectType;

public class ConstantPool
implements Node {
    private Constant[] pool;
    private int poolSize;
    private Map utf8Cache = new HashMap();
    private Map methodCache = new HashMap();
    private Map fieldCache = new HashMap();

    public int getSize() {
        return this.poolSize;
    }

    public ConstantPool() {
        this.pool = new Constant[10];
        this.poolSize = 0;
    }

    public ConstantPool(Constant[] constants) {
        this.pool = constants;
        this.poolSize = constants == null ? 0 : constants.length;
    }

    ConstantPool(DataInputStream file) throws IOException {
        this.poolSize = file.readUnsignedShort();
        this.pool = new Constant[this.poolSize];
        int i = 1;
        while (i < this.poolSize) {
            this.pool[i] = Constant.readConstant(file);
            byte tag = this.pool[i].getTag();
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
    }

    public Constant getConstant(int index, byte tag) {
        Constant c = this.getConstant(index);
        if (c.tag == tag) {
            return c;
        }
        throw new ClassFormatException("Expected class '" + Constants.CONSTANT_NAMES[tag] + "' at index " + index + " and found " + c);
    }

    public Constant getConstant(int index) {
        if (index >= this.pool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.pool.length);
        }
        return this.pool[index];
    }

    public ConstantPool copy() {
        Constant[] newConstants = new Constant[this.poolSize];
        int i = 1;
        while (i < this.poolSize) {
            if (this.pool[i] != null) {
                newConstants[i] = this.pool[i].copy();
            }
            ++i;
        }
        return new ConstantPool(newConstants);
    }

    public String getConstantString(int index, byte tag) throws ClassFormatException {
        int i;
        Constant c = this.getConstant(index, tag);
        switch (tag) {
            case 7: {
                i = ((ConstantClass)c).getNameIndex();
                break;
            }
            case 8: {
                i = ((ConstantString)c).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + tag);
            }
        }
        c = this.getConstant(i, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String constantToString(Constant c) {
        String str;
        switch (c.tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                str = "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).getBytes();
                break;
            }
            case 6: {
                str = Double.toString(((ConstantDouble)c).getBytes());
                break;
            }
            case 4: {
                str = Float.toString(((ConstantFloat)c).getBytes());
                break;
            }
            case 5: {
                str = Long.toString(((ConstantLong)c).getBytes());
                break;
            }
            case 3: {
                str = Integer.toString(((ConstantInteger)c).getBytes());
                break;
            }
            case 12: {
                str = String.valueOf(this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1)) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                str = String.valueOf(this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7)) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + c.tag);
            }
        }
        return str;
    }

    private static final String escape(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len + 5);
        char[] ch = str.toCharArray();
        int i = 0;
        while (i < len) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String constantToString(int index, byte tag) {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void accept(ClassVisitor v) {
        v.visitConstantPool(this);
    }

    public Constant[] getConstantPool() {
        return this.pool;
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.poolSize);
        int i = 1;
        while (i < this.poolSize) {
            if (this.pool[i] != null) {
                this.pool[i].dump(file);
            }
            ++i;
        }
    }

    public ConstantUtf8 getConstantUtf8(int idx) {
        try {
            Constant c = this.pool[idx];
            if (c == null) {
                throw new ClassFormatException("Constant pool at index " + idx + " is null.");
            }
            if (c.tag != 1) {
                throw new ClassFormatException("Expected UTF8Constant  at index " + idx + " and got " + c);
            }
            return (ConstantUtf8)c;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new ClassFormatException("Index " + idx + " into constant pool (size:" + this.poolSize + ") is invalid");
        }
    }

    public String getConstantString_CONSTANTClass(int index) {
        ConstantClass c = (ConstantClass)this.getConstant(index, (byte)7);
        index = c.getNameIndex();
        return ((ConstantUtf8)this.getConstant(index, (byte)1)).getBytes();
    }

    public int getLength() {
        return this.poolSize;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 1;
        while (i < this.poolSize) {
            buf.append(String.valueOf(i) + ")" + this.pool[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public int lookupInteger(int n) {
        int i = 1;
        while (i < this.poolSize) {
            ConstantInteger c;
            if (this.pool[i] instanceof ConstantInteger && (c = (ConstantInteger)this.pool[i]).getBytes() == n) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupUtf8(String string) {
        Integer pos = (Integer)this.utf8Cache.get(string);
        if (pos != null) {
            return pos;
        }
        int i = 1;
        while (i < this.poolSize) {
            Constant c = this.pool[i];
            if (c != null && c.tag == 1 && ((ConstantUtf8)c).getBytes().equals(string)) {
                this.utf8Cache.put(string, new Integer(i));
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupClass(String classname) {
        int i = 1;
        while (i < this.poolSize) {
            int cIndex;
            String cName;
            Constant c = this.pool[i];
            if (c != null && c.tag == 7 && (cName = ((ConstantUtf8)this.pool[cIndex = ((ConstantClass)c).getNameIndex()]).getBytes()).equals(classname)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addUtf8(String n) {
        int ret = this.lookupUtf8(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantUtf8(n);
        return ret;
    }

    public int addInteger(int n) {
        int ret = this.lookupInteger(n);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantInteger(n);
        return ret;
    }

    public int addArrayClass(ArrayType type) {
        return this.addClass(type.getSignature());
    }

    public int addClass(ObjectType type) {
        return this.addClass(type.getClassName());
    }

    public int addClass(String classname) {
        String toAdd = classname.replace('.', '/');
        int ret = this.lookupClass(toAdd);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ConstantClass c = new ConstantClass(this.addUtf8(toAdd));
        ret = this.poolSize;
        this.pool[this.poolSize++] = c;
        return ret;
    }

    private void adjustSize() {
        if (this.poolSize + 3 >= this.pool.length) {
            Constant[] cs = this.pool;
            this.pool = new Constant[cs.length + 8];
            System.arraycopy(cs, 0, this.pool, 0, cs.length);
        }
        if (this.poolSize == 0) {
            this.poolSize = 1;
        }
    }

    public int addFieldref(String class_name, String field_name, String signature) {
        int ret = this.lookupFieldref(class_name, field_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(field_name, signature);
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantFieldref(class_index, name_and_type_index);
        return ret;
    }

    public int lookupFieldref(String searchClassname, String searchFieldname, String searchSignature) {
        String k = (searchClassname = searchClassname.replace('.', '/')) + searchFieldname + searchSignature;
        Integer pos = (Integer)this.fieldCache.get(k);
        if (pos != null) {
            return pos;
        }
        int i = 1;
        while (i < this.poolSize) {
            Constant c = this.pool[i];
            if (c != null && c.tag == 9) {
                String typeSignature;
                String name;
                ConstantFieldref cfr = (ConstantFieldref)c;
                ConstantNameAndType cnat = (ConstantNameAndType)this.pool[cfr.getNameAndTypeIndex()];
                int cIndex = cfr.getClassIndex();
                ConstantClass cc = (ConstantClass)this.pool[cIndex];
                String cName = ((ConstantUtf8)this.pool[cc.getNameIndex()]).getBytes();
                if (cName.equals(searchClassname) && (name = ((ConstantUtf8)this.pool[cnat.getNameIndex()]).getBytes()).equals(searchFieldname) && (typeSignature = ((ConstantUtf8)this.pool[cnat.getSignatureIndex()]).getBytes()).equals(searchSignature)) {
                    this.fieldCache.put(k, new Integer(i));
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int addNameAndType(String name, String signature) {
        int ret = this.lookupNameAndType(name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_index = this.addUtf8(name);
        int signature_index = this.addUtf8(signature);
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantNameAndType(name_index, signature_index);
        return ret;
    }

    public int lookupNameAndType(String searchName, String searchTypeSignature) {
        int i = 1;
        while (i < this.poolSize) {
            String typeSignature;
            ConstantNameAndType cnat;
            String name;
            Constant c = this.pool[i];
            if (c != null && c.tag == 12 && (name = ((ConstantUtf8)this.pool[(cnat = (ConstantNameAndType)c).getNameIndex()]).getBytes()).equals(searchName) && (typeSignature = ((ConstantUtf8)this.pool[cnat.getSignatureIndex()]).getBytes()).equals(searchTypeSignature)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addFloat(float f) {
        int ret = this.lookupFloat(f);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantFloat(f);
        return ret;
    }

    public int lookupFloat(float f) {
        int bits = Float.floatToIntBits(f);
        int i = 1;
        while (i < this.poolSize) {
            ConstantFloat cf;
            Constant c = this.pool[i];
            if (c != null && c.tag == 4 && Float.floatToIntBits((cf = (ConstantFloat)c).getBytes()) == bits) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addDouble(double d) {
        int ret = this.lookupDouble(d);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.poolSize;
        this.pool[this.poolSize] = new ConstantDouble(d);
        this.poolSize += 2;
        return ret;
    }

    public int lookupDouble(double d) {
        long bits = Double.doubleToLongBits(d);
        int i = 1;
        while (i < this.poolSize) {
            ConstantDouble cf;
            Constant c = this.pool[i];
            if (c != null && c.tag == 6 && Double.doubleToLongBits((cf = (ConstantDouble)c).getBytes()) == bits) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addLong(long l) {
        int ret = this.lookupLong(l);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        ret = this.poolSize;
        this.pool[this.poolSize] = new ConstantLong(l);
        this.poolSize += 2;
        return ret;
    }

    public int lookupString(String s) {
        int i = 1;
        while (i < this.poolSize) {
            ConstantString cs;
            ConstantUtf8 cu8;
            Constant c = this.pool[i];
            if (c != null && c.tag == 8 && (cu8 = (ConstantUtf8)this.pool[(cs = (ConstantString)c).getStringIndex()]).getBytes().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addString(String str) {
        int ret = this.lookupString(str);
        if (ret != -1) {
            return ret;
        }
        int utf8 = this.addUtf8(str);
        this.adjustSize();
        ConstantString s = new ConstantString(utf8);
        ret = this.poolSize;
        this.pool[this.poolSize++] = s;
        return ret;
    }

    public int lookupLong(long l) {
        int i = 1;
        while (i < this.poolSize) {
            ConstantLong cf;
            Constant c = this.pool[i];
            if (c != null && c.tag == 5 && (cf = (ConstantLong)c).getBytes() == l) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addConstant(Constant c, ConstantPool cp) {
        Constant[] constants = cp.getConstantPool();
        switch (c.getTag()) {
            case 8: {
                ConstantString s = (ConstantString)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getStringIndex()];
                return this.addString(u8.getBytes());
            }
            case 7: {
                ConstantClass s = (ConstantClass)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[s.getNameIndex()];
                return this.addClass(u8.getBytes());
            }
            case 12: {
                ConstantNameAndType n = (ConstantNameAndType)c;
                ConstantUtf8 u8 = (ConstantUtf8)constants[n.getNameIndex()];
                ConstantUtf8 u8_2 = (ConstantUtf8)constants[n.getSignatureIndex()];
                return this.addNameAndType(u8.getBytes(), u8_2.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)c).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)c).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)c).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)c).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)c).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP m = (ConstantCP)c;
                ConstantClass clazz = (ConstantClass)constants[m.getClassIndex()];
                ConstantNameAndType n = (ConstantNameAndType)constants[m.getNameAndTypeIndex()];
                ConstantUtf8 u8 = (ConstantUtf8)constants[clazz.getNameIndex()];
                String class_name = u8.getBytes().replace('/', '.');
                u8 = (ConstantUtf8)constants[n.getNameIndex()];
                String name = u8.getBytes();
                u8 = (ConstantUtf8)constants[n.getSignatureIndex()];
                String signature = u8.getBytes();
                switch (c.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(class_name, name, signature);
                    }
                    case 10: {
                        return this.addMethodref(class_name, name, signature);
                    }
                    case 9: {
                        return this.addFieldref(class_name, name, signature);
                    }
                }
                throw new RuntimeException("Unknown constant type " + c);
            }
        }
        throw new RuntimeException("Unknown constant type " + c);
    }

    public int addMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int name_and_type_index = this.addNameAndType(method_name, signature);
        int class_index = this.addClass(class_name);
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantMethodref(class_index, name_and_type_index);
        return ret;
    }

    public int addInterfaceMethodref(String class_name, String method_name, String signature) {
        int ret = this.lookupInterfaceMethodref(class_name, method_name, signature);
        if (ret != -1) {
            return ret;
        }
        this.adjustSize();
        int class_index = this.addClass(class_name);
        int name_and_type_index = this.addNameAndType(method_name, signature);
        ret = this.poolSize;
        this.pool[this.poolSize++] = new ConstantInterfaceMethodref(class_index, name_and_type_index);
        return ret;
    }

    public int lookupInterfaceMethodref(String searchClassname, String searchMethodName, String searchSignature) {
        searchClassname = searchClassname.replace('.', '/');
        int i = 1;
        while (i < this.poolSize) {
            String typeSignature;
            ConstantNameAndType cnat;
            String name;
            ConstantInterfaceMethodref cfr;
            ConstantClass cc;
            String cName;
            Constant c = this.pool[i];
            if (c != null && c.tag == 11 && (cName = ((ConstantUtf8)this.pool[(cc = (ConstantClass)this.pool[(cfr = (ConstantInterfaceMethodref)c).getClassIndex()]).getNameIndex()]).getBytes()).equals(searchClassname) && (name = ((ConstantUtf8)this.pool[(cnat = (ConstantNameAndType)this.pool[cfr.getNameAndTypeIndex()]).getNameIndex()]).getBytes()).equals(searchMethodName) && (typeSignature = ((ConstantUtf8)this.pool[cnat.getSignatureIndex()]).getBytes()).equals(searchSignature)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupMethodref(String searchClassname, String searchMethodName, String searchSignature) {
        String key = searchClassname + searchMethodName + searchSignature;
        Integer cached = (Integer)this.methodCache.get(key);
        if (cached != null) {
            return cached;
        }
        searchClassname = searchClassname.replace('.', '/');
        int i = 1;
        while (i < this.poolSize) {
            Constant c = this.pool[i];
            if (c != null && c.tag == 10) {
                String typeSignature;
                String name;
                ConstantMethodref cfr = (ConstantMethodref)c;
                ConstantNameAndType cnat = (ConstantNameAndType)this.pool[cfr.getNameAndTypeIndex()];
                int cIndex = cfr.getClassIndex();
                ConstantClass cc = (ConstantClass)this.pool[cIndex];
                String cName = ((ConstantUtf8)this.pool[cc.getNameIndex()]).getBytes();
                if (cName.equals(searchClassname) && (name = ((ConstantUtf8)this.pool[cnat.getNameIndex()]).getBytes()).equals(searchMethodName) && (typeSignature = ((ConstantUtf8)this.pool[cnat.getSignatureIndex()]).getBytes()).equals(searchSignature)) {
                    this.methodCache.put(key, new Integer(i));
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] cs = new Constant[this.poolSize];
        System.arraycopy(this.pool, 0, cs, 0, this.poolSize);
        return new ConstantPool(cs);
    }
}

