/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.ServerStreamConnection;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.server.XmlRpcHttpServer;
import org.apache.xmlrpc.webserver.Connection;
import org.apache.xmlrpc.webserver.RequestData;

class ConnectionServer
extends XmlRpcHttpServer {
    ConnectionServer() {
    }

    protected void writeError(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Throwable pError) throws XmlRpcException {
        RequestData data = (RequestData)pConfig;
        try {
            if (data.isByteArrayRequired()) {
                super.writeError(pConfig, pStream, pError);
                data.getConnection().writeError(data, pError, (ByteArrayOutputStream)pStream);
            } else {
                data.getConnection().writeErrorHeader(data, pError, -1);
                super.writeError(pConfig, pStream, pError);
                pStream.flush();
            }
        }
        catch (IOException e) {
            throw new XmlRpcException(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeResponse(XmlRpcStreamRequestConfig pConfig, OutputStream pStream, Object pResult) throws XmlRpcException {
        RequestData data = (RequestData)pConfig;
        try {
            if (data.isByteArrayRequired()) {
                super.writeResponse(pConfig, pStream, pResult);
                data.getConnection().writeResponse(data, pStream);
            } else {
                data.getConnection().writeResponseHeader(data, -1);
                super.writeResponse(pConfig, pStream, pResult);
                pStream.flush();
            }
        }
        catch (IOException e) {
            throw new XmlRpcException(e.getMessage(), (Throwable)e);
        }
    }

    protected void setResponseHeader(ServerStreamConnection pConnection, String pHeader, String pValue) {
        ((Connection)pConnection).setResponseHeader(pHeader, pValue);
    }
}

