/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.utils;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.utils.AbstractLinksBuilderImpl;
import org.apache.wink.server.utils.SingleLinkBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleLinkBuilderImpl
extends AbstractLinksBuilderImpl<SingleLinkBuilder>
implements SingleLinkBuilder {
    private String rel = null;
    private MediaType type = null;

    public SingleLinkBuilderImpl(MessageContext context) {
        super(context);
    }

    @Override
    public SingleLinkBuilder type(MediaType type) {
        this.type = type;
        return this;
    }

    @Override
    public SingleLinkBuilder rel(String rel) {
        this.rel = rel;
        return this;
    }

    @Override
    public List<SyndLink> build(List<SyndLink> out) {
        if (out == null) {
            out = new LinkedList<SyndLink>();
        }
        UriBuilder builder = this.initUriBuilder();
        if (this.subResourcePath != null && this.subResourcePath.length() > 0) {
            builder.path(this.subResourcePath);
        }
        for (String query : this.queryParams.keySet()) {
            builder.queryParam(query, ((List)this.queryParams.get((Object)query)).toArray());
        }
        if (this.type != null && this.addAltParam && this.queryParams.get((Object)"alt") == null) {
            builder.replaceQueryParam("alt", new Object[]{MediaTypeUtils.toEncodedString((MediaType)this.type)});
        }
        return this.build(out, builder);
    }

    private List<SyndLink> build(List<SyndLink> out, UriBuilder builder) {
        SyndLink link;
        if (("self".equals(this.rel) || "edit".equals(this.rel)) && (link = this.getLink(out, this.rel)) != null) {
            out.remove(link);
        }
        URI href = builder.buildFromEncodedMap(this.pathParams);
        out.add(this.createLink(this.rel, this.type, href));
        return out;
    }
}

