/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.util.Locale;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;

public class FloatConverter
extends AbstractDecimalConverter<Float> {
    private static final long serialVersionUID = 1L;
    public static final IConverter<Float> INSTANCE = new FloatConverter();

    @Override
    public Float convertToObject(String value, Locale locale) {
        Object number = this.parse(value, -3.4028234663852886E38, 3.4028234663852886E38, locale);
        if (number == null) {
            return null;
        }
        return Float.valueOf(((Number)number).floatValue());
    }

    @Override
    protected Class<Float> getTargetType() {
        return Float.class;
    }
}

