/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;
import org.apache.wicket.util.string.Strings;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;

    @Override
    public Date convertToObject(String value, Locale locale) {
        if (value == null || Strings.isEmpty(value)) {
            return null;
        }
        return (Date)this.parse(this.getDateFormat(locale), value, locale);
    }

    @Override
    public String convertToString(Date value, Locale locale) {
        DateFormat dateFormat = this.getDateFormat(locale);
        if (dateFormat != null) {
            return dateFormat.format(value);
        }
        return value.toString();
    }

    public DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return DateFormat.getDateInstance(3, locale);
    }

    @Override
    protected Class<Date> getTargetType() {
        return Date.class;
    }
}

