/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.guice.GuiceInjectorHolder;
import org.apache.wicket.proxy.IProxyTargetLocator;

class GuiceProxyTargetLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private final Annotation bindingAnnotation;
    private final boolean optional;
    private final String className;
    private final String fieldName;

    public GuiceProxyTargetLocator(Field field, Annotation bindingAnnotation, boolean optional) {
        this.bindingAnnotation = bindingAnnotation;
        this.optional = optional;
        this.className = field.getDeclaringClass().getName();
        this.fieldName = field.getName();
    }

    public Object locateProxyTarget() {
        Type type;
        GuiceInjectorHolder holder = (GuiceInjectorHolder)Application.get().getMetaData(GuiceInjectorHolder.INJECTOR_KEY);
        try {
            Class clazz = WicketObjects.resolveClass((String)this.className);
            Field field = clazz.getDeclaredField(this.fieldName);
            type = field.getGenericType();
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Error accessing member: " + this.fieldName + " of class: " + this.className, (Throwable)e);
        }
        Key key = this.bindingAnnotation == null ? Key.get((TypeLiteral)TypeLiteral.get((Type)type)) : Key.get((TypeLiteral)TypeLiteral.get((Type)type), (Annotation)this.bindingAnnotation);
        Injector injector = holder.getInjector();
        if (this.optional) {
            try {
                if (injector.getBinding(key) == null) {
                    return null;
                }
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return injector.getInstance(key);
    }
}

