/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.breadcrumb.BreadCrumbLink;
import org.apache.wicket.extensions.breadcrumb.DefaultBreadCrumbsModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class BreadCrumbBar
extends Panel
implements IBreadCrumbModel {
    private static final long serialVersionUID = 1L;
    private final IBreadCrumbModel decorated = new DefaultBreadCrumbsModel();

    public BreadCrumbBar(String id) {
        super(id);
        BreadCrumbsListView breadCrumbsListView = new BreadCrumbsListView("crumbs");
        this.addListener(breadCrumbsListView);
        this.add(new Component[]{breadCrumbsListView});
    }

    @Override
    public void addListener(IBreadCrumbModelListener listener) {
        this.decorated.addListener(listener);
    }

    @Override
    public List<IBreadCrumbParticipant> allBreadCrumbParticipants() {
        return this.decorated.allBreadCrumbParticipants();
    }

    @Override
    public IBreadCrumbParticipant getActive() {
        return this.decorated.getActive();
    }

    @Override
    public void removeListener(IBreadCrumbModelListener listener) {
        this.decorated.removeListener(listener);
    }

    @Override
    public void setActive(IBreadCrumbParticipant breadCrumbParticipant) {
        this.decorated.setActive(breadCrumbParticipant);
    }

    protected boolean getEnableLinkToCurrent() {
        return false;
    }

    protected String getSeparatorMarkup() {
        return "/";
    }

    protected Component newBreadCrumbComponent(String id, long index, int total, IBreadCrumbParticipant breadCrumbParticipant) {
        boolean enableLink = this.getEnableLinkToCurrent() || index < (long)(total - 1);
        return new BreadCrumbComponent(id, this.getSeparatorMarkup(), index, this, breadCrumbParticipant, enableLink);
    }

    protected void onDetach() {
        super.onDetach();
        for (IBreadCrumbParticipant crumb : this.decorated.allBreadCrumbParticipants()) {
            if (crumb instanceof Component) {
                ((Component)crumb).detach();
                continue;
            }
            if (!(crumb instanceof IDetachable)) continue;
            ((IDetachable)crumb).detach();
        }
    }

    protected class BreadCrumbsListView
    extends ListView<IBreadCrumbParticipant>
    implements IBreadCrumbModelListener {
        private static final long serialVersionUID = 1L;
        private transient boolean dirty;
        private transient int size;

        public BreadCrumbsListView(String id) {
            super(id);
            this.dirty = false;
            this.size = 0;
            this.setReuseItems(false);
            this.setDefaultModel((IModel)new LoadableDetachableModel<List<IBreadCrumbParticipant>>(){
                private static final long serialVersionUID = 1L;

                protected List<IBreadCrumbParticipant> load() {
                    ArrayList<IBreadCrumbParticipant> l = new ArrayList<IBreadCrumbParticipant>(BreadCrumbBar.this.allBreadCrumbParticipants());
                    BreadCrumbsListView.this.size = l.size();
                    return l;
                }
            });
        }

        @Override
        public void breadCrumbActivated(IBreadCrumbParticipant previousParticipant, IBreadCrumbParticipant breadCrumbParticipant) {
            this.signalModelChange();
        }

        @Override
        public void breadCrumbAdded(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        @Override
        public void breadCrumbRemoved(IBreadCrumbParticipant breadCrumbParticipant) {
        }

        private void signalModelChange() {
            this.getDefaultModel().detach();
        }

        protected void onBeforeRender() {
            super.onBeforeRender();
            if (this.dirty) {
                this.dirty = false;
            }
        }

        protected void populateItem(ListItem<IBreadCrumbParticipant> item) {
            long index = item.getIndex();
            IBreadCrumbParticipant breadCrumbParticipant = (IBreadCrumbParticipant)item.getDefaultModelObject();
            item.add(new Component[]{BreadCrumbBar.this.newBreadCrumbComponent("crumb", index, this.size, breadCrumbParticipant)});
        }
    }

    private static final class BreadCrumbComponent
    extends Panel {
        private static final long serialVersionUID = 1L;

        public BreadCrumbComponent(String id, String separatorMarkup, long index, IBreadCrumbModel breadCrumbModel, final IBreadCrumbParticipant breadCrumbParticipant, boolean enableLink) {
            super(id);
            this.add(new Component[]{new Label("sep", (Serializable)((Object)(index > 0L ? separatorMarkup : ""))).setEscapeModelStrings(false).setRenderBodyOnly(true)});
            BreadCrumbLink link = new BreadCrumbLink("link", breadCrumbModel){
                private static final long serialVersionUID = 1L;

                @Override
                protected IBreadCrumbParticipant getParticipant(String componentId) {
                    return breadCrumbParticipant;
                }
            };
            link.setEnabled(enableLink);
            this.add(new Component[]{link});
            link.add(new Component[]{new Label("label", breadCrumbParticipant.getTitle()).setRenderBodyOnly(true)});
        }
    }
}

