/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.util.lang.Comparators;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AjaxLazyLoadPanel<T extends Component>
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_ID = "content";
    private boolean loaded;

    public AjaxLazyLoadPanel(String id) {
        this(id, null);
    }

    public AjaxLazyLoadPanel(String id, IModel<?> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    protected boolean isContentReady() {
        return true;
    }

    public Component getLoadingComponent(String id) {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
        return new Label(id, (Serializable)((Object)("<img alt=\"Loading...\" src=\"" + RequestCycle.get().urlFor((IRequestHandler)handler) + "\"/>"))).setEscapeModelStrings(false);
    }

    public abstract T getLazyLoadComponent(String var1);

    protected void onContentLoaded(T content, Optional<AjaxRequestTarget> target) {
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.loaded) {
            this.initTimer();
        }
    }

    protected void initTimer() {
        List behaviors = this.getPage().getBehaviors(AjaxLazyLoadTimer.class);
        if (behaviors.isEmpty()) {
            AjaxLazyLoadTimer timer = new AjaxLazyLoadTimer();
            this.getPage().add(new Behavior[]{timer});
            this.getRequestCycle().find(AjaxRequestTarget.class).ifPresent(target -> timer.restart((IPartialPageRequestHandler)target));
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.get(CONTENT_ID) == null) {
            this.add(new Component[]{this.getLoadingComponent(CONTENT_ID)});
        }
    }

    protected Duration getUpdateInterval() {
        return Duration.ofSeconds(1L);
    }

    protected final boolean isLoaded() {
        if (!this.loaded && this.isContentReady()) {
            this.loaded = true;
            T content = this.getLazyLoadComponent(CONTENT_ID);
            this.replace((Component)content);
            Optional target = this.getRequestCycle().find(AjaxRequestTarget.class);
            this.onContentLoaded(content, target);
            target.ifPresent(t -> t.add(new Component[]{this}));
        }
        return this.loaded;
    }

    static class AjaxLazyLoadTimer
    extends AbstractAjaxTimerBehavior {
        private static final long serialVersionUID = 1L;

        public AjaxLazyLoadTimer() {
            super(Duration.ofSeconds(1L));
        }

        protected void onTimer(AjaxRequestTarget target) {
            this.load(target);
        }

        public void load(AjaxRequestTarget target) {
            this.setUpdateInterval(Duration.ofMillis(Long.MAX_VALUE));
            this.getComponent().getPage().visitChildren(AjaxLazyLoadPanel.class, new IVisitor<AjaxLazyLoadPanel<?>, Void>(){

                public void component(AjaxLazyLoadPanel<?> panel, IVisit<Void> visit) {
                    if (panel.isVisibleInHierarchy() && !panel.isLoaded()) {
                        Duration updateInterval = panel.getUpdateInterval();
                        if (this.getUpdateInterval() == null) {
                            throw new IllegalArgumentException("update interval must not ben null");
                        }
                        this.setUpdateInterval((Duration)Comparators.min((Comparable)this.getUpdateInterval(), (Comparable)updateInterval));
                    }
                }
            });
            if (Duration.ofMillis(Long.MAX_VALUE).equals(this.getUpdateInterval())) {
                this.stop((IPartialPageRequestHandler)target);
                this.getComponent().remove(new Behavior[]{this});
            }
        }
    }
}

